/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import java.io.UnsupportedEncodingException;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.DotParts;
import org.jfrog.security.crypto.JFrogBase58;
import org.jfrog.security.crypto.JFrogEnvelop;
import org.jfrog.security.crypto.JFrogHintedBase58Parser;

public enum EncodingType {
    NO_ENCODING('0', '0'){

        @Override
        public boolean isEncodedByMe(String in) {
            return false;
        }

        @Override
        public byte[] decode(String in) {
            return 1.stringToBytes(in);
        }

        @Override
        public String encode(byte[] toEncode) {
            return 1.bytesToString(toEncode);
        }
    }
    ,
    SAVED_PRIVATE_KEY('J', 'R'),
    SAVED_PUBLIC_KEY('J', 'U'),
    SYMMETRIC_KEY('J', 'S'),
    ARTIFACTORY_PASSWORD('A', 'P'),
    ARTIFACTORY_PRIVATE_KEY('A', 'R'),
    ARTIFACTORY_PUBLIC_KEY('A', 'U'),
    ARTIFACTORY_MASTER('A', 'M'),
    ARTIFACTORY_API_KEY('A', 'K'),
    MASTER_LEVEL('J', 'E'),
    JFROG_AES_256('J', 'H'),
    JFROG_TOKEN('J', 'T'),
    JFMC_MASTER('M', 'M');

    private static final String UTF8 = "UTF-8";
    private final char first;
    private final char second;

    private EncodingType(char first, char second) {
        this.first = first;
        this.second = second;
    }

    public static EncodingType findEncodedBy(String in) {
        DotParts part = EncodingType.takeDotParts(in);
        if (part == null) {
            return null;
        }
        return EncodingType.findEncodedBy(part);
    }

    static EncodingType findEncodedBy(DotParts part) {
        if (part == null) {
            return null;
        }
        for (EncodingType encodingType : EncodingType.values()) {
            if (!encodingType.startsWithMarkers(part.input)) continue;
            return encodingType;
        }
        return null;
    }

    public static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public static byte[] stringToBytes(String string) {
        try {
            return string.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private boolean startsWithMarkers(String in) {
        return in != null && in.length() >= 2 && in.charAt(0) == this.first && in.charAt(1) == this.second;
    }

    public boolean isEncodedByMe(String in) {
        return this.startsWithMarkers(in) && EncodingType.takeDotParts(in) != null;
    }

    public byte[] decode(String in) {
        if (!this.startsWithMarkers(in)) {
            return null;
        }
        JFrogEnvelop res = JFrogEnvelop.parse(in);
        return res == null ? null : res.extractBytes();
    }

    static DotParts takeDotParts(String in) {
        return JFrogHintedBase58Parser.parse(in, 2);
    }

    public String encode(byte[] toEncode) {
        return "" + this.first + this.second + JFrogBase58.encode(JFrogBase58.bytesToEncode(toEncode));
    }

    public String encodeFormat(String keyId, CipherAlg alg, byte[] toEncode) {
        return JFrogHintedBase58Parser.build("" + this.first + this.second, keyId, alg, JFrogBase58.bytesToEncode(toEncode));
    }

    public boolean isEncryptedFormat() {
        if (this == ARTIFACTORY_PASSWORD) {
            return true;
        }
        if (this == ARTIFACTORY_PRIVATE_KEY) {
            return true;
        }
        if (this == ARTIFACTORY_PUBLIC_KEY) {
            return true;
        }
        if (this == ARTIFACTORY_MASTER) {
            return true;
        }
        if (this == MASTER_LEVEL) {
            return true;
        }
        if (this == JFROG_AES_256) {
            return true;
        }
        return this == JFMC_MASTER;
    }
}

