/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.crypto;

import javax.annotation.Nullable;
import org.jfrog.security.crypto.CipherAlg;
import org.jfrog.security.crypto.JFrogBase58;
import org.jfrog.security.crypto.JFrogCryptoHelper;
import org.jfrog.security.crypto.JFrogHintedBase58Parser;

public class DotParts {
    public final String input;
    public final int offset;
    private static final int LEN = 5;
    private static final int PAYLOAD_CELL = 0;
    private static final int ALG_CELL = 1;
    private static final int KEYID_CELL = 2;
    private static final int REST_CELL = 3;
    private int[] dots = new int[5];

    DotParts(String input, int offset) {
        this.input = input;
        DotParts.dotParse(this.dots, input, offset);
        this.offset = offset;
    }

    static void dotParse(int[] arr, String input, int offset) {
        int i;
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = -1;
        }
        if (input == null || offset >= input.length()) {
            return;
        }
        arr[0] = offset;
        int idx = input.length();
        for (i = 0; i < 5; ++i) {
            if ((idx = input.lastIndexOf(46, idx - 1)) < offset) {
                arr[i] = offset;
                break;
            }
            arr[i] = idx + 1;
        }
        if (arr[3] > offset) {
            for (i = 0; i < arr.length; ++i) {
                arr[i] = -1;
            }
        }
    }

    byte[] getPayload() {
        int idx = this.getDataOffset();
        if (idx < 0) {
            return null;
        }
        return JFrogBase58.decode(this.input, idx);
    }

    private int getDataOffset() {
        return this.dots[0];
    }

    @Nullable
    public String getKeyId() {
        int idx = this.dots[2];
        int till = this.dots[1] - 1;
        if (idx < 0) {
            return null;
        }
        return this.input.substring(idx, till);
    }

    @Nullable
    String getAlgString() {
        int idx = this.dots[1];
        int till = this.dots[0] - 1;
        if (idx < 0) {
            return null;
        }
        return this.input.substring(idx, till);
    }

    @Nullable
    CipherAlg getAlg() {
        String algString = this.getAlgString();
        if (algString == null) {
            return null;
        }
        return CipherAlg.valueOf(algString);
    }

    public String toString() {
        return JFrogCryptoHelper.debugMessageForSensitiveStrings(this.input);
    }

    boolean isBase58Data() {
        return JFrogHintedBase58Parser.isBase58(this.input, this.getDataOffset());
    }
}

