/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.security.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.jfrog.common.ClockUtils;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.EncryptionWrapperFactory;
import org.jfrog.security.crypto.SecretProvider;
import org.jfrog.security.file.SecurityFolderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtils {
    private static final Logger log = LoggerFactory.getLogger(KeyUtils.class);

    private KeyUtils() {
    }

    public static void saveKeyToFile(File keyFile, EncryptionWrapper keyWrapper) {
        boolean created;
        if (!keyFile.getParentFile().exists() && !(created = keyFile.getParentFile().mkdirs())) {
            log.warn("Unable to create directory {}!", (Object)keyFile.getParentFile().getPath());
        }
        try {
            SecretKey secretKey = ((SecretProvider)((Object)keyWrapper)).getSecret();
            byte[] keyBytes = secretKey.getEncoded();
            byte[] encodedBytes = Hex.encode((byte[])keyBytes);
            Path keyPath = Files.write(keyFile.toPath(), encodedBytes, new OpenOption[0]);
            SecurityFolderHelper.setPermissionsOnSecurityFile(keyPath, SecurityFolderHelper.PERMISSIONS_MODE_600);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not save key " + keyFile.getName(), e);
        }
    }

    public static String readKeyFromFile(File joinKeyFile) throws IOException {
        return StringUtils.trim((String)FileUtils.readFileToString((File)joinKeyFile));
    }

    public static void initKey(File keyFile, String key) {
        EncryptionWrapper keyWrapper = EncryptionWrapperFactory.aesKeyWrapperFromString(key);
        KeyUtils.saveKeyToFile(keyFile, keyWrapper);
    }

    public static void waitForKey(File keyFile, long timeout) {
        long start = ClockUtils.epochMillis();
        String path = keyFile.getAbsolutePath();
        while (!keyFile.exists() && ClockUtils.epochMillis() < start + timeout) {
            try {
                log.warn("{} not found, waiting for sync...", (Object)keyFile.getName());
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.debug("Interrupted while waiting for {} to be made available at '{}'", (Object)keyFile.getName(), (Object)path);
                Thread.currentThread().interrupt();
            }
            log.debug("Still waiting for {} file to be made available at '{}'", (Object)keyFile.getName(), (Object)path);
        }
        if (!keyFile.exists()) {
            throw new IllegalStateException("Timed out waiting for " + keyFile.getName() + " file to be made available at " + path);
        }
    }
}

