package org.jfrog.security.masterkey.status;

import javax.annotation.concurrent.Immutable;

/**
 * Db Model for the master key status
 *
 * @author Shay Bagants
 */
@Immutable
public class DbMasterKeyStatus {

    private String kid;
    private DbMasterKeyStatusEnum status;
    private String setByNodeId;
    private long expires;

    public DbMasterKeyStatus(String kid, DbMasterKeyStatusEnum status, String setByNodeId, long expires) {
        this.kid = kid;
        this.status = status;
        this.setByNodeId = setByNodeId;
        this.expires = expires;
    }

    public String getKid() {
        return this.kid;
    }

    public DbMasterKeyStatusEnum getStatus() {
        return this.status;
    }

    public String getSetByNodeId() {
        return this.setByNodeId;
    }

    public long getExpires() {
        return this.expires;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DbMasterKeyStatus that = (DbMasterKeyStatus) o;

        if (expires != that.expires) {
            return false;
        }
        if (kid != null ? !kid.equals(that.kid) : that.kid != null) {
            return false;
        }
        if (status != that.status) {
            return false;
        }
        return setByNodeId != null ? setByNodeId.equals(that.setByNodeId) : that.setByNodeId == null;
    }

    @Override
    public int hashCode() {
        int result = kid != null ? kid.hashCode() : 0;
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (setByNodeId != null ? setByNodeId.hashCode() : 0);
        result = 31 * result + (int) (expires ^ (expires >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "DbMasterKeyStatus(" +
                "kid='" + kid + '\'' +
                ", status=" + status +
                ", setByNodeId='" + setByNodeId + '\'' +
                ", expires=" + expires +
                ')';
    }


    public enum DbMasterKeyStatusEnum {
        on
    }
}
