package org.jfrog.security.masterkey;

import org.jfrog.security.masterkey.status.DbMasterKeyStatus;
import org.jfrog.security.masterkey.status.MasterKeyStatus;
import org.jfrog.security.masterkey.status.MasterKeyStatusDao;

public class MasterKeyStorageBase implements MasterKeyStorage {

    private final MasterKeyStatusDao masterKeyDao;

    public MasterKeyStorageBase(MasterKeyStatusDao masterKeyDao) {
        this.masterKeyDao = masterKeyDao;
    }

    @Override
    public boolean isKeyExists(String keyFingerprint) {
        return masterKeyDao.exists(keyFingerprint);
    }

    @Override
    public boolean insertMasterKey(MasterKeyStatus keyStatus) {
        DbMasterKeyStatus.DbMasterKeyStatusEnum status = DbMasterKeyStatus.DbMasterKeyStatusEnum
                .valueOf(keyStatus.getStatus().name());
        DbMasterKeyStatus dbMasterKeyStatus = new DbMasterKeyStatus(keyStatus.getKid(), status,
                keyStatus.getSetByNodeId(), keyStatus.getExpires());
        masterKeyDao.addMasterKeyStatus(dbMasterKeyStatus);
        return true;
    }

    @Override
    public MasterKeyStatus getMasterKeyInfo() {
        DbMasterKeyStatus key = masterKeyDao.getMasterKeyStatus();
        if (key == null) {
            return null;
        }
        MasterKeyStatus.MasterKeyStatusEnum status = MasterKeyStatus.MasterKeyStatusEnum.valueOf(key.getStatus().name());
        return new MasterKeyStatus(key.getKid(), status, key.getSetByNodeId(), key.getExpires());
    }
}
