package org.jfrog.security.crypto.signing.jws;


/**
 *  Jws Signing And Verification
 *
 * @author Tomer Mayost
 */
public interface Jws {

    /**
     * Sign Json Payload According to Jws Spec - RFC 7515
     *
     * @param jsonPayload  The payload to sign
     * @param privateKey GPG Key of Type RSA or ECC (NIST Curve), Minimum Key strength is NIST P-256 (Recommended)
     * @param passphrase   Used to decipher the private key (use "" for keys without passphrase)
     *
     * @return base64 Jws Signed String
     */
    String createJwsSignature(byte[] jsonPayload, byte[] privateKey, String passphrase);

    /**
     * Verify Signed Content According to Jws Spec - RFC 7515
     *
     * Supports Keys of type GPG ECC (NIST)
     *
     * @param publicKey GPG Keys of Type RSA or ECC (NIST Curve), Minimum Key strength is NIST P-256 (Recommended)
     * @param base64JwsSignedString The signed content to verify
     *
     * @return True if verified
     */
    boolean verifyJwsSignature(byte[] publicKey, String base64JwsSignedString);
}
