package org.jfrog.security.crypto.result;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Shay Bagants
 */
public class DecryptionStatusHolder {

    private List<DecryptionStatus> statuses = new ArrayList<>();

    /**
     * Indicates that a fallback key was used during the decryption
     */
    public void addSuccessWithFallback() {
        statuses.add(DecryptionStatus.SUCCESS_WITH_FALLBACK);
    }

    public boolean hadFallback() {
        return statuses.contains(DecryptionStatus.SUCCESS_WITH_FALLBACK);
    }
}
