/*
 * Copyright (c) 2017. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto;

// https://en.wikipedia.org/wiki/Cryptography_standards
public enum CipherAlg {
    DESede("DESede"),
    // AES has by default random IV seed)
    AES128("AES128", true),
    RSA("RSA"),
    DUMMY("Dummy"),;
    // java requires additional jar
    //AES256;

    public final String name;

    CipherAlg(String name, boolean randomSeed) {
        this.name = name;
        this.isRandomlySeeded = randomSeed;
    }

    CipherAlg(String name) {
        // default no random seed - plain text, DESede...
        this(name, false);
    }

    final public boolean isRandomlySeeded;
}
