/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package org.jfrog.security.crypto;

import org.jfrog.security.crypto.encrypter.BytesEncrypterBase;

import javax.annotation.Nonnull;
import java.security.PrivateKey;
import java.security.PublicKey;

class AsymKeyBytesEncrypter extends BytesEncrypterBase {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public AsymKeyBytesEncrypter(PublicKey publicKey, PrivateKey privateKey) {
        super(privateKey.getEncoded());
        this.publicKey = publicKey;
        this.privateKey=privateKey;
    }

    @Override
    public CipherAlg getCipherAlg() {
        return CipherAlg.RSA;
    }


    @Nonnull
    @Override
    public byte[] encrypt(@Nonnull byte[] bytes) {
        return JFrogCryptoHelper.encryptAsymmetric(bytes, publicKey);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        if (privateKey == null) {
            throw new IllegalStateException("Cannot decrypt without private key! This wrapper can only only encrypt!");
        }
        return JFrogCryptoHelper.decryptAsymmetric(bytes, privateKey);
    }
}
