package org.jfrog.security.common;

import java.nio.CharBuffer;
import java.security.SecureRandom;
import java.util.Random;

/**
 * @author Shay Bagants
 */
public class CredsUtils {
    /**
     * Generate a password in a given length
     *
     * @param length the length of the password
     * @return the generated password
     */
    public static CharSequence generatePassword(int length) {
        char[] password = new char[length];
        Random random = new SecureRandom();
        for (int i = 0; i < length; i++) {
            password[i] = PASSWORD_CHARS.charAt(random.nextInt(PASSWORD_CHARS.length()));
        }
        return CharBuffer.wrap(password);
    }

    private static final String PASSWORD_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%^&_+-";
}
