/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.metadata.client.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.common.JsonUtils;
import org.jfrog.metadata.client.model.MetadataAttribute;
import org.jfrog.metadata.client.model.SortTypeEnum;

public class AqlLikeBuilder {
    private String collection;
    private Map<String, String> filters;
    private List<MetadataAttribute> includes;
    private Integer limit;
    private Integer offset;
    private SortTypeEnum sortType;
    private List<String> sortAttributes;

    public String query() {
        List attributes = this.includes.stream().map(MetadataAttribute::getAttributeName).collect(Collectors.toList());
        String query = this.collection + ".find(" + JsonUtils.getInstance().writeValueAsString(this.filters) + ").include(" + StringUtils.wrap((String)StringUtils.join(attributes, (String)"\", \""), (String)"\"") + ")";
        if (this.limit != null) {
            query = query + ".limit(" + this.limit + ")";
        }
        if (this.offset != null) {
            query = query + ".offset(" + this.offset + ")";
        }
        return this.addSortElementIfNeeded(query);
    }

    private String addSortElementIfNeeded(String collection) {
        if (this.sortType != null) {
            return collection + ".sort(" + JsonUtils.getInstance().writeValueAsString(Collections.singletonMap(this.sortType.getAqlName(), this.sortAttributes)) + ")";
        }
        return collection;
    }

    AqlLikeBuilder(String collection, Map<String, String> filters, List<MetadataAttribute> includes, Integer limit, Integer offset, SortTypeEnum sortType, List<String> sortAttributes) {
        this.collection = collection;
        this.filters = filters;
        this.includes = includes;
        this.limit = limit;
        this.offset = offset;
        this.sortType = sortType;
        this.sortAttributes = sortAttributes;
    }

    public static AqlLikeBuilderBuilder builder() {
        return new AqlLikeBuilderBuilder();
    }

    public static class AqlLikeBuilderBuilder {
        private String collection;
        private Map<String, String> filters;
        private List<MetadataAttribute> includes;
        private Integer limit;
        private Integer offset;
        private SortTypeEnum sortType;
        private List<String> sortAttributes;

        AqlLikeBuilderBuilder() {
        }

        public AqlLikeBuilderBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public AqlLikeBuilderBuilder filters(Map<String, String> filters) {
            this.filters = filters;
            return this;
        }

        public AqlLikeBuilderBuilder includes(List<MetadataAttribute> includes) {
            this.includes = includes;
            return this;
        }

        public AqlLikeBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AqlLikeBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AqlLikeBuilderBuilder sortType(SortTypeEnum sortType) {
            this.sortType = sortType;
            return this;
        }

        public AqlLikeBuilderBuilder sortAttributes(List<String> sortAttributes) {
            this.sortAttributes = sortAttributes;
            return this;
        }

        public AqlLikeBuilder build() {
            return new AqlLikeBuilder(this.collection, this.filters, this.includes, this.limit, this.offset, this.sortType, this.sortAttributes);
        }

        public String toString() {
            return "AqlLikeBuilder.AqlLikeBuilderBuilder(collection=" + this.collection + ", filters=" + this.filters + ", includes=" + this.includes + ", limit=" + this.limit + ", offset=" + this.offset + ", sortType=" + this.sortType + ", sortAttributes=" + this.sortAttributes + ")";
        }
    }
}

