/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.metadata.client.model;

import com.google.common.base.CaseFormat;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.common.JsonUtils;
import org.jfrog.metadata.client.model.MetadataEntity;

public class MetadataFieldRecordingProxy
implements InvocationHandler {
    private Set<String> populatedFields = new HashSet<String>();
    private MetadataEntity entity;

    public MetadataFieldRecordingProxy(MetadataEntity entity) {
        this.entity = entity;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue;
        String name = method.getName();
        if ("toJsonMerge".equals(name)) {
            return JsonUtils.toJsonMerge((Object)this.entity, this.populatedFields);
        }
        if (name.startsWith("get") || "toString".equals(name)) {
            return method.invoke((Object)this.entity, args);
        }
        if (name.startsWith("set")) {
            this.populatedFields.add(StringUtils.substringAfter((String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name), (String)"set_"));
        }
        if ((returnValue = method.invoke((Object)this.entity, args)) != null && this.entity.getClass().isAssignableFrom(returnValue.getClass())) {
            return proxy;
        }
        return returnValue;
    }

    public String toJsonMerge() {
        return JsonUtils.toJsonMerge((Object)this.entity, this.populatedFields);
    }
}

