/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.metadata.client.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jfrog.client.http.CloseableHttpClientDecorator;
import org.jfrog.client.http.HttpRequest;
import org.jfrog.client.http.RestRequest;
import org.jfrog.client.http.RestResponse;
import org.jfrog.client.http.RestResponseImpl;
import org.jfrog.metadata.client.exception.MetadataClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataHttpClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MetadataHttpClient.class);
    private final CloseableHttpClientDecorator httpClient;
    private final String serviceAuthToken;
    private String metadataServerUrl;
    private static final String API_V1 = "/api/v1";
    private static final Pattern CONTENT_TYPE_APP_JSON_PATTERN = Pattern.compile("application/(json|.+\\+json).*");

    public MetadataHttpClient(CloseableHttpClientDecorator httpClient, String metadataServerUrl, String serviceAuthToken) {
        this.metadataServerUrl = metadataServerUrl;
        this.httpClient = httpClient;
        this.serviceAuthToken = serviceAuthToken;
    }

    public RestResponse rest(@Nonnull RestRequest request, boolean throwOnUnsuccessfulResponse) {
        return this.rest(request, null, throwOnUnsuccessfulResponse);
    }

    public RestResponse rest(@Nonnull RestRequest request, String activePrincipalAuthToken, boolean throwOnUnsuccessfulResponse) {
        RestResponse restResponse;
        block9: {
            HttpRequestBase httpRequest = HttpRequest.fromRestRequest((RestRequest)request, (String)this.metadataServerUrl, (RequestConfig)this.httpClient.getDefaultRequestConfig());
            CloseableHttpResponse response = this.restWithoutClose(httpRequest, activePrincipalAuthToken);
            try {
                restResponse = this.createRestResponse(response, throwOnUnsuccessfulResponse, request.getPath());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (throwOnUnsuccessfulResponse) {
                        throw new MetadataClientException("Unable to send request to '" + httpRequest.getURI() + "'. Caught IO Exception", e);
                    }
                    log.error("Caught IO Exception while executing {}. Exception message: {}", (Object)request.getPath(), (Object)e.getMessage());
                    log.debug("", (Throwable)e);
                    return null;
                }
            }
            response.close();
        }
        return restResponse;
    }

    public CloseableHttpResponse restWithoutClose(@Nonnull RestRequest request, String activePrincipalAuthToken) throws IOException {
        HttpRequestBase httpRequest = HttpRequest.fromRestRequest((RestRequest)request, (String)this.metadataServerUrl, (RequestConfig)this.httpClient.getDefaultRequestConfig());
        return this.restWithoutClose(httpRequest, activePrincipalAuthToken);
    }

    private CloseableHttpResponse restWithoutClose(@Nonnull HttpRequestBase httpRequest, String activePrincipalAuthToken) throws IOException {
        this.addAuthentication(activePrincipalAuthToken, httpRequest);
        log.debug("Executing : {} {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getURI());
        return this.httpClient.execute((HttpUriRequest)httpRequest);
    }

    public void adHocPing() {
        this.rest(RestRequest.get((String)"/api/v1/system/ping").build(), null, true);
    }

    private void addAuthentication(String activePrincipalAuthToken, HttpRequestBase request) {
        if (StringUtils.isNotBlank((String)activePrincipalAuthToken)) {
            request.addHeader((Header)new BasicHeader("Authorization", "Bearer " + activePrincipalAuthToken));
        } else if (StringUtils.isNotBlank((String)this.serviceAuthToken)) {
            request.addHeader((Header)new BasicHeader("Authorization", "Bearer " + this.serviceAuthToken));
        }
    }

    private RestResponse createRestResponse(CloseableHttpResponse response, boolean throwOnUnsuccessfulResponse, String requestPath) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (throwOnUnsuccessfulResponse && statusCode >= 300) {
            try {
                String message = this.extractErrorMessage((HttpResponse)response);
                throw new IllegalStateException("Failed executing " + requestPath + ", with response code: " + response.getStatusLine() + " and response message: " + message);
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly((HttpEntity)entity);
                throw throwable;
            }
        }
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        Charset charset = contentType == null ? null : contentType.getCharset();
        byte[] bytes = entity == null ? null : EntityUtils.toByteArray((HttpEntity)entity);
        return new RestResponseImpl(statusCode, bytes, charset);
    }

    private String extractErrorMessage(HttpResponse response) {
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null && this.isApplicationJsonResponse(response) && entity.getContentLength() < 1024L) {
                return IOUtils.toString((InputStream)entity.getContent(), (Charset)Charsets.UTF_8);
            }
        }
        catch (Exception e) {
            log.debug("Unable to extract error message from response.", (Throwable)e);
        }
        return response.getStatusLine().getReasonPhrase();
    }

    private boolean isApplicationJsonResponse(HttpResponse response) {
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : null;
        return contentType != null && CONTENT_TYPE_APP_JSON_PATTERN.matcher(contentType).matches();
    }

    @Override
    public void close() {
        this.closeClient();
    }

    private void closeClient() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new MetadataClientException("Failed to shutdown the http client", e);
        }
    }
}

