package org.jfrog.metadata.client.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Uriah Levy
 */
@EqualsAndHashCode
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MetadataPackageImpl implements MetadataPackage {

    private String pkgid;
    private String packageType;
    private String name;
    private List<MetadataQualifierEntity> qualifiers;
    private String description;
    private String websiteUrl;
    private String vcsUrl;
    private String issuesUrl;
    private List<String> creatorIdentityUrls;
    private String created;
    private List<MetadataLicense> licenses;
    private Boolean respectsSemver;
    private String modified;
    private String edited;
    private String latestVersion;
    private List<MetadataVersion> versions = new ArrayList<>();
    private MetadataPackageStatsEntity stats;
    private int rating;
    private List<MetadataPackageTagEntity> tags;
    private List<MetadataUserProperty> userProperties;
    private List<PackageInfoSourcesMetadata> packageInfoSources;

    @Override
    public void setPkgid(String pkgid) {
        this.pkgid = pkgid;
    }

    @Override
    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setQualifiers(List<MetadataQualifierEntity> qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }

    @Override
    public void setVcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
    }

    @Override
    public void setIssuesUrl(String issuesUrl) {
        this.issuesUrl = issuesUrl;
    }

    @Override
    public void setCreatorIdentityUrls(List<String> creatorIdentityUrls) {
        this.creatorIdentityUrls = creatorIdentityUrls;
    }

    @Override
    public void setCreated(String created) {
        this.created = created;
    }

    @Override
    public void setLicenses(List<MetadataLicense> licenses) {
        this.licenses = licenses;
    }

    @Override
    public void setRespectsSemver(Boolean respectsSemver) {
        this.respectsSemver = respectsSemver;
    }

    @Override
    public void setModified(String modified) {
        this.modified = modified;
    }

    @Override
    public void setEdited(String edited) {
        this.edited = edited;
    }

    @Override
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Override
    public void setVersions(List<MetadataVersion> versions) {
        this.versions = versions;
    }

    @Override
    public void setStats(MetadataPackageStatsEntity stats) {
        this.stats = stats;
    }

    @Override
    public void setRating(int rating) {
        this.rating = rating;
    }

    @Override
    public void setTags(List<MetadataPackageTagEntity> tags) {
        this.tags = tags;
    }

    @Override
    public void setUserProperties(List<MetadataUserProperty> userProperties) {
        this.userProperties = userProperties;
    }

    @Override
    public void setPackageInfoSources(
            List<PackageInfoSourcesMetadata> packageInfoSources) {
        this.packageInfoSources = packageInfoSources;
    }

    public String getPkgid() {
        return pkgid;
    }

    @Override
    public String getPackageType() {
        return packageType;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<MetadataQualifierEntity> getQualifiers() {
        return qualifiers;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getWebsiteUrl() {
        return websiteUrl;
    }

    @Override
    public String getVcsUrl() {
        return vcsUrl;
    }

    @Override
    public String getIssuesUrl() {
        return issuesUrl;
    }

    @Override
    public List<String> getCreatorIdentityUrls() {
        return creatorIdentityUrls;
    }

    public String getCreated() {
        return created;
    }

    @Override
    public List<MetadataLicense> getLicenses() {
        return licenses;
    }

    public Boolean getRespectsSemver() {
        return respectsSemver;
    }

    @Override
    public String getModified() {
        return modified;
    }

    @Override
    public String getEdited() {
        return edited;
    }

    @Override
    public String getLatestVersion() {
        return latestVersion;
    }

    @Override
    public List<MetadataVersion> getVersions() {
        return versions;
    }

    @Override
    public MetadataPackageStatsEntity getStats() {
        return stats;
    }

    @Override
    public int getRating() {
        return rating;
    }

    @Override
    public List<MetadataPackageTagEntity> getTags() {
        return tags;
    }

    @Override
    public List<MetadataUserProperty> getUserProperties() {
        return userProperties;
    }

    @Override
    public List<PackageInfoSourcesMetadata> getPackageInfoSources() {
        return packageInfoSources;
    }

    @Override
    public String toJsonMerge() {
        throw new IllegalStateException("Implemented in proxy");
    }
}

