package org.jfrog.metadata.client.model;

import com.fasterxml.jackson.core.type.TypeReference;
import org.jfrog.metadata.client.rest.SearchResponse;

public enum MetadataElement {

    PACKAGE("packages", new TypeReference<SearchResponse<MetadataPackageImpl>>() {}),
    VERSION("versions", new TypeReference<SearchResponse<MetadataVersion>>() {});

    private final TypeReference typeRef;
    private final String collectionName;

    MetadataElement(String collectionName, TypeReference searchResponseTypeReference) {
        this.typeRef = searchResponseTypeReference;
        this.collectionName = collectionName;
    }

    public TypeReference getTypeRef() {
        return typeRef;
    }

    public String getCollectionName() {
        return collectionName;
    }
}