package org.jfrog.metadata.client;

import org.jfrog.client.http.model.ProxyConfig;

/**
 * @author Uriah Levy
 */
public abstract class MetadataClientBuilder {

    public static MetadataClientBuilder newBuilder() {
        try {
            Class<?> builderClass = Class.forName(MetadataClientBuilder.class.getName() + "Impl");
            return (MetadataClientBuilder) builderClass.newInstance();
        } catch (Exception e) {
            throw new RuntimeException("Failed to create a MetadataClientBuilder instance.", e);
        }
    }

    /**
     * Create a new {@link MetadataClient} from the settings in this builder
     */
    public abstract MetadataClient create();

    /**
     * Set the Metadata server URL
     *
     * @param serverUrl the Metadata server URL
     * @return this builder
     */
    public abstract MetadataClientBuilder serverUrl(String serverUrl);

    public abstract String getServerUrl();

    /**
     * Set the Metadata server AuthToken
     *
     * @param authToken the Metadata server AuthToken
     * @return this builder
     */
    public abstract MetadataClientBuilder authToken(String authToken);

    public abstract String getAuthToken();


    /**
     * Set the connection timeout for the HTTP client
     *
     * @param connectTimeout connection timeout in milliseconds
     * @return this builder
     */
    public abstract MetadataClientBuilder connectionTimeout(int connectTimeout);

    public abstract int getConnectionTimeout();

    /**
     * Set the socket timeout for the HTTP client
     *
     * @param socketTimeout socket timeout in milliseconds
     * @return this builder
     */
    public abstract MetadataClientBuilder socketTimeout(int socketTimeout);

    public abstract int getSocketTimeout();

    /**
     * Set the max amount of connections for this HTTP client
     *
     * @param maxConnections - the number of max connections
     * @return this builder
     */
    public abstract MetadataClientBuilder maxConnections(int maxConnections);

    public abstract int getMaxConnections();

    /**
     * Set the {@link ProxyConfig} of this HTTP client builder
     *
     * @param proxyConfig - the Proxy Config to set
     * @return this builder
     */
    public abstract MetadataClientBuilder proxyConfig(ProxyConfig proxyConfig);

    public abstract ProxyConfig getProxyConfig();
}