/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.wrappers;

public enum FileEventType {
    DELETE("ENTRY_DELETE"),
    CREATE("ENTRY_CREATE"),
    MODIFY("ENTRY_MODIFY");

    String eventTypeName;

    private FileEventType(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public String getName() {
        return this.eventTypeName;
    }

    public static FileEventType fromValue(String eventTypeName) {
        switch (eventTypeName) {
            case "ENTRY_DELETE": {
                return DELETE;
            }
            case "ENTRY_CREATE": {
                return CREATE;
            }
            case "ENTRY_MODIFY": {
                return MODIFY;
            }
        }
        throw new IllegalArgumentException("No such file event type '" + eventTypeName + "'");
    }

    public String toString() {
        switch (this.eventTypeName) {
            case "ENTRY_DELETE": {
                return "delete";
            }
            case "ENTRY_CREATE": {
                return "create";
            }
            case "ENTRY_MODIFY": {
                return "modify";
            }
        }
        throw new IllegalArgumentException("No such file event type '" + this.eventTypeName + "'");
    }
}

