/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.wrappers;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.PosixFilePermission;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.jfrog.client.util.PathUtils;
import org.jfrog.config.BroadcastChannel;
import org.jfrog.config.ConfigsDataAccessObject;
import org.jfrog.config.ConfigurationManager;
import org.jfrog.config.ConfigurationManagerInternal;
import org.jfrog.config.DbChannel;
import org.jfrog.config.DbTimestampHelper;
import org.jfrog.config.Home;
import org.jfrog.config.LogChannel;
import org.jfrog.config.db.DBConfigWithTimestamp;
import org.jfrog.config.watch.FileWatchingManager;
import org.jfrog.config.wrappers.ConfigImportHandler;
import org.jfrog.config.wrappers.ConfigWrapper;
import org.jfrog.config.wrappers.ConfigWrapperImpl;
import org.jfrog.config.wrappers.ConfigurationManagerAdapter;
import org.jfrog.config.wrappers.DefaultFileProvider;
import org.jfrog.config.wrappers.FileEventType;
import org.jfrog.config.wrappers.SharedConfigMetadata;
import org.jfrog.config.wrappers.SharedFolderMetadata;
import org.jfrog.security.file.SecurityFolderHelper;

public class ConfigurationManagerImpl
implements ConfigurationManager,
ConfigurationManagerInternal {
    private static final String DEFAULT_DB_PROPERTIES_RESOURCE = "/META-INF/default/db/derby.properties";
    private final FileWatchingManager javaFileWatcher;
    private long timeGap;
    private Home home;
    private ConfigurationManagerAdapter adapter;
    private ConfigsDataAccessObject configsDao;
    private Map<String, ConfigWrapper> sharedConfigsByFile;
    private boolean fileSyncStarted;
    private ConfigImportHandler configImportHandler;

    public static ConfigurationManager create(ConfigurationManagerAdapter adapter) {
        return new ConfigurationManagerImpl(adapter, FileWatchingManager::create);
    }

    public static ConfigurationManager create(ConfigurationManagerAdapter adapter, FileWatchingManager fileWatchingManager) {
        return new ConfigurationManagerImpl(adapter, thiz -> fileWatchingManager);
    }

    private ConfigurationManagerImpl(ConfigurationManagerAdapter adapter, Function<ConfigurationManagerImpl, FileWatchingManager> fileWatcher) {
        this.home = adapter.getHome();
        this.adapter = adapter;
        this.sharedConfigsByFile = Maps.newHashMap();
        this.javaFileWatcher = fileWatcher.apply(this);
        this.configsDao = new ConfigsDataAccessObject(this);
        this.adapter.initialize();
        this.configImportHandler = new ConfigImportHandler(this);
    }

    @Override
    public void startSync() {
        try {
            boolean configsTableExist = this.configsDao.isConfigsTableExist();
            if (this.fileSyncStarted) {
                this.log().debug("File sync already started, no need to re-initiate.");
                return;
            }
            if (!configsTableExist) {
                this.initDefaultFiles();
                this.log().debug("Config table doesn't exist, file sync will not start.");
                return;
            }
            this.log().info("Starting file sync");
            this.fileSyncStarted = true;
            this.timeGap = DbTimestampHelper.getTimeGapBetweenServerAndDb(this.getDBChannel());
            this.javaFileWatcher.registerDirectoryListener(this.home.getEtcDir());
            this.configImportHandler.handleImport();
            this.initSharedConfigs();
            this.initSharedFolders();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start file sync to db: " + e.getMessage(), e);
        }
        this.initDefaultFiles();
    }

    @Override
    public void initDefaultFiles() {
        for (DefaultFileProvider defaultFileProvider : this.adapter.getDefaultConfigs()) {
            defaultFileProvider.create();
        }
    }

    private void initSharedConfigs() {
        for (SharedConfigMetadata sharedFile : this.adapter.getSharedConfigs()) {
            try {
                this.registerConfig(sharedFile);
            }
            catch (Exception e) {
                this.log().error("Failed to register shared file.", e);
            }
        }
    }

    private void initSharedFolders() {
        for (SharedFolderMetadata sharedFile : this.adapter.getSharedFolders()) {
            try {
                this.registerFolder(sharedFile);
            }
            catch (Exception e) {
                this.log().error("Failed to register shared file.", e);
            }
        }
    }

    @Override
    public void initDbProperties() {
        File dbProps = this.home.getDBPropertiesFile();
        try {
            if (dbProps.exists()) {
                return;
            }
            URL url = this.home.getClass().getResource(DEFAULT_DB_PROPERTIES_RESOURCE);
            if (url == null) {
                throw new RuntimeException("Could not read classpath resource '/META-INF/default/db/derby.properties'.");
            }
            FileUtils.copyURLToFile((URL)url, (File)dbProps);
            boolean success = dbProps.setLastModified(System.currentTimeMillis());
            if (!success) {
                throw new RuntimeException("Failed to modify the Last modification time for file: " + dbProps.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create the default '/META-INF/default/db/derby.properties' at '" + dbProps.getAbsolutePath() + "'.", e);
        }
    }

    private void registerFolder(SharedFolderMetadata metadata) throws IOException, SQLException {
        File[] files;
        String prefixConfigName = metadata.getPrefixConfigName();
        File folder = metadata.getFolder();
        boolean encrypted = metadata.isEncrypted();
        boolean protectedConfig = metadata.isProtectedConfig();
        if (folder == null) {
            return;
        }
        if (!prefixConfigName.endsWith(".") && !prefixConfigName.endsWith("/")) {
            throw new IllegalArgumentException("Prefix config name for folder must end with dot or slash, it was " + prefixConfigName);
        }
        FileUtils.forceMkdir((File)folder);
        this.javaFileWatcher.registerDirectoryListener(folder, prefixConfigName);
        if (folder.exists() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                String name = prefixConfigName + file.getName();
                if (file.isDirectory()) {
                    this.registerFolder(new SharedFolderMetadata(file, name + "/", encrypted, protectedConfig));
                    continue;
                }
                this.registerConfig(new SharedConfigMetadata(file, name, null, false, encrypted, protectedConfig));
            }
        }
        List<DBConfigWithTimestamp> configs = this.configsDao.getConfigs(prefixConfigName, encrypted, this.home);
        for (DBConfigWithTimestamp metaData : configs) {
            String configName = metaData.getName();
            String fileName = configName.replaceFirst(prefixConfigName, "");
            File file = new File(folder, fileName);
            if (this.isExcluded(configName)) {
                this.log().debug("Skipping registry of:" + configName + " file, the file is excluded");
                continue;
            }
            this.registerConfig(new SharedConfigMetadata(file, configName, null, false, encrypted, protectedConfig));
        }
    }

    private void registerConfig(SharedConfigMetadata sharedFile) throws IOException {
        File file = sharedFile.getFile();
        String absolutePath = file.getAbsolutePath();
        if (this.sharedConfigsByFile.get(absolutePath) != null) {
            return;
        }
        if (this.isExcluded(sharedFile.getConfigName())) {
            this.log().debug("Skipping registry of:" + absolutePath + " file, the file is excluded");
            return;
        }
        ConfigWrapperImpl configWrapper = new ConfigWrapperImpl(sharedFile, this, this.getPermissionsFor(file), this.home);
        this.sharedConfigsByFile.put(absolutePath, configWrapper);
    }

    private boolean isExcluded(String configName) {
        boolean blackList = this.adapter.getBlackListConfigs().stream().anyMatch(configName::contains);
        boolean whiteListFiles = this.adapter.getSharedConfigs().stream().anyMatch(listItem -> configName.contains(listItem.getConfigName()));
        return !whiteListFiles && blackList;
    }

    @Override
    public void fileChanged(File file, String configPrefix, WatchEvent.Kind<Path> eventType, long timestamp) {
        this.adapter.bind();
        String eventTypeName = eventType.name();
        String filePath = file.getAbsolutePath();
        if (!this.allowDbUpdates()) {
            this.log().debug("Local file event '" + eventTypeName + "' intercepted for file '" + filePath + "', but this node is not the primary. This change will not be propagated to other nodes, and the file may be overwritten when an event from the master node is intercepted for it.");
            return;
        }
        this.fileChanged(file, configPrefix, FileEventType.fromValue(eventTypeName), this.sharedConfigsByFile.get(filePath));
        this.adapter.unbind();
    }

    @Override
    public void forceFileChanged(File file, String configPrefix, FileEventType eventType) {
        ConfigWrapper configWrapper = this.sharedConfigsByFile.get(file.getAbsolutePath());
        this.fileChanged(file, configPrefix, eventType, configWrapper);
    }

    @Override
    public boolean allowDbUpdates() {
        return this.adapter.allowDbUpdate();
    }

    private void fileChanged(File file, String configPrefix, FileEventType eventType, ConfigWrapper configWrapper) {
        try {
            switch (eventType) {
                case DELETE: {
                    this.handleFileDeletedEvent(file, configWrapper);
                    break;
                }
                case CREATE: {
                    this.handleFileCreatedEvent(file, configPrefix, configWrapper);
                    break;
                }
                case MODIFY: {
                    this.handleFileModifiedEvent(configWrapper);
                }
            }
        }
        catch (Exception e) {
            this.log().error("Config manager Failed to handle file change for file: " + file.getAbsolutePath(), e);
        }
    }

    private void handleFileModifiedEvent(ConfigWrapper configWrapper) throws IOException, SQLException {
        if (configWrapper != null) {
            configWrapper.modified();
        }
    }

    private void handleFileCreatedEvent(File file, String configPrefix, ConfigWrapper configWrapper) throws IOException, SQLException {
        if (configWrapper != null) {
            configWrapper.create();
        } else if (!this.home.getEtcDir().getAbsolutePath().equals(file.getParentFile().getAbsolutePath())) {
            boolean encrypted = file.getAbsolutePath().startsWith(this.home.getSecurityDir().getAbsolutePath());
            if (file.isDirectory()) {
                this.registerFolder(new SharedFolderMetadata(file, configPrefix + file.getName() + "/", encrypted, false));
            } else {
                this.registerConfig(new SharedConfigMetadata(file, configPrefix + file.getName(), null, false, encrypted, false));
                ConfigWrapper child = this.sharedConfigsByFile.get(file.getAbsolutePath());
                if (child != null) {
                    child.create();
                }
            }
        }
    }

    private void handleFileDeletedEvent(File file, ConfigWrapper configWrapper) throws SQLException {
        if (configWrapper != null) {
            configWrapper.remove();
            if (!this.home.getEtcDir().getAbsolutePath().equals(file.getParentFile().getAbsolutePath())) {
                this.sharedConfigsByFile.remove(file.getAbsolutePath());
            }
        }
    }

    @Override
    public void destroy() {
        this.javaFileWatcher.destroy();
    }

    @Override
    public void remoteConfigChanged(String configName, FileEventType eventType) throws Exception {
        this.handleByConfigPrefix(configName);
        for (Map.Entry<String, ConfigWrapper> entry : this.sharedConfigsByFile.entrySet()) {
            if (!entry.getValue().getName().equals(configName)) continue;
            switch (eventType) {
                case MODIFY: {
                    entry.getValue().remoteModified();
                    break;
                }
                case CREATE: {
                    entry.getValue().remoteCreate();
                    break;
                }
                case DELETE: {
                    entry.getValue().remoteRemove();
                }
            }
        }
    }

    private void handleByConfigPrefix(String configName) throws IOException, SQLException {
        String securityPrefix;
        String uiPrefix;
        String pluginPrefix = "artifactory.plugin.";
        if (configName.startsWith(pluginPrefix)) {
            File eventFile = this.resolvePath(this.home.getPluginsDir(), pluginPrefix, configName);
            this.doRecursive(eventFile, this.home.getPluginsDir(), true, configName, false);
        }
        if (configName.startsWith(uiPrefix = "artifactory.ui.")) {
            File eventFile = this.resolvePath(this.home.getLogoDir(), uiPrefix, configName);
            this.doRecursive(eventFile, this.home.getLogoDir(), true, configName, false);
        }
        if (configName.startsWith(securityPrefix = "artifactory.security.")) {
            File eventFile = this.resolvePath(this.home.getSecurityDir(), securityPrefix, configName);
            this.doRecursive(eventFile, this.home.getSecurityDir(), true, configName, true);
        }
    }

    private void doRecursive(File temp, File root, boolean file, String name, boolean encrypted) throws IOException, SQLException {
        if (temp.getAbsolutePath().equals(root.getAbsolutePath())) {
            return;
        }
        this.doRecursive(temp.getParentFile(), root, false, PathUtils.getParent((String)name) + "/", encrypted);
        ConfigWrapper configWrapper = this.sharedConfigsByFile.get(temp.getAbsolutePath());
        if (configWrapper == null) {
            if (file) {
                this.registerConfig(new SharedConfigMetadata(temp, name, null, false, encrypted, false));
            } else {
                this.registerFolder(new SharedFolderMetadata(temp, name, encrypted, false));
            }
        }
    }

    private File resolvePath(File baseFile, String prefix, String name) {
        String path = name.replace(prefix, "");
        return new File(baseFile, path);
    }

    private Set<PosixFilePermission> getPermissionsFor(File confFile) {
        if (confFile.getAbsolutePath().contains(this.home.getSecurityDir().getPath())) {
            return SecurityFolderHelper.PERMISSIONS_MODE_600;
        }
        return null;
    }

    @Override
    public ConfigsDataAccessObject getConfigsDao() {
        return this.configsDao;
    }

    public Home getHome() {
        return this.home;
    }

    @Override
    public long getNormalizedTime(long timestamp) {
        return timestamp - this.timeGap;
    }

    @Override
    public long getDeNormalizedTime(long timestamp) {
        return timestamp + this.timeGap;
    }

    @Override
    public void setPermanentLogChannel() {
        this.adapter.setPermanentLogChannel();
    }

    @Override
    public void setPermanentBroadcastChannel(BroadcastChannel broadcastChannel) {
        this.adapter.setPermanentBroadcastChannel(broadcastChannel);
    }

    @Override
    public DbChannel getDBChannel() {
        return this.adapter.getDbChannel();
    }

    @Override
    public LogChannel getLogChannel() {
        return this.log();
    }

    private LogChannel log() {
        return this.adapter.getLogChannel();
    }

    @Override
    public void setPermanentDBChannel(DbChannel permanentDbChannel) {
        this.adapter.setPermanentDBChannel(permanentDbChannel);
        this.startSync();
    }

    @Override
    public int getRetryAmount() {
        return this.adapter.getRetryAmount();
    }

    @Override
    public String getName() {
        return this.adapter.getName();
    }

    @Override
    public ConfigurationManagerAdapter getAdapter() {
        return this.adapter;
    }
}

