/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.wrappers;

import java.io.File;
import org.jfrog.config.ConfigsDataAccessObject;
import org.jfrog.config.Home;
import org.jfrog.config.db.FileConfigWithTimestamp;
import org.jfrog.config.utils.TimeProvider;
import org.jfrog.config.wrappers.ConfigurationManagerAdapter;
import org.jfrog.config.wrappers.ConfigurationManagerImpl;
import org.jfrog.config.wrappers.SharedConfigMetadata;
import org.jfrog.security.file.SecurityFolderHelper;

class ConfigImportHandler {
    private static final String IMPORT_EXTENTION = ".import";
    private final TimeProvider timeProvider;
    private final ConfigurationManagerAdapter adapter;
    private final ConfigsDataAccessObject configsDao;
    private final Home home;

    ConfigImportHandler(ConfigurationManagerImpl configurationManager) {
        this.adapter = configurationManager.getAdapter();
        this.configsDao = configurationManager.getConfigsDao();
        this.timeProvider = configurationManager;
        this.home = configurationManager.getHome();
    }

    void handleImport() {
        this.adapter.getSharedConfigs().stream().filter(config -> config.getConfigCallback() != null).forEach(this::onStart);
    }

    private void onStart(SharedConfigMetadata config) {
        File oldFile = config.getFile();
        File importFile = new File(oldFile.getAbsolutePath() + IMPORT_EXTENTION);
        try {
            if (!importFile.exists()) {
                return;
            }
            this.adapter.getLogChannel().info("Starting import for config: " + oldFile.getAbsolutePath());
            this.uploadConfig(config, importFile);
            this.renameConfig(config, oldFile, importFile);
            config.getConfigCallback().doImport(config, this.adapter, this.home, this.timeProvider, this.configsDao);
            this.adapter.getLogChannel().info("Finished import for config: " + oldFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.adapter.getLogChannel().error("Failed to import config: " + oldFile.getAbsolutePath(), e);
            throw e;
        }
    }

    private void renameConfig(SharedConfigMetadata config, File oldFile, File importFile) {
        try {
            if (oldFile.exists()) {
                SecurityFolderHelper.removeKeyFile((File)oldFile);
                boolean renamed = importFile.renameTo(config.getFile());
                if (!renamed) {
                    throw new RuntimeException("Failed to import config: " + oldFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            this.adapter.getLogChannel().error("Failed to import config: " + oldFile.getAbsolutePath(), e);
            throw e;
        }
    }

    private void uploadConfig(SharedConfigMetadata config, File importFile) {
        boolean uploaded = false;
        for (int numberOfTries = 0; !uploaded && numberOfTries < 10; ++numberOfTries) {
            uploaded = this.tryToUploadConfigToDb(importFile, config);
        }
        if (!uploaded) {
            String msg = "Failed to insert config: " + importFile.getAbsolutePath() + " to db";
            this.adapter.getLogChannel().debug(msg);
            throw new RuntimeException(msg);
        }
    }

    private boolean tryToUploadConfigToDb(File importFile, SharedConfigMetadata config) {
        FileConfigWithTimestamp fileConfigWithTimestamp = new FileConfigWithTimestamp(importFile, this.timeProvider);
        try {
            this.configsDao.setConfig(config.getConfigName(), fileConfigWithTimestamp, config.isEncrypted(), this.home);
        }
        catch (Exception e) {
            this.adapter.getLogChannel().debug("Failed to insert config: " + importFile.getAbsolutePath() + " to db");
            return false;
        }
        return true;
    }
}

