/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.watch;

import com.google.common.collect.Maps;
import java.io.File;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jfrog.config.watch.FileChangedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatchingManager {
    @Nonnull
    private final WatchService watcher;
    @Nonnull
    private final Thread watchThread;
    private boolean runWatch = true;
    private Map<WatchKey, ConfigInfo> configInfos;
    private FileChangedListener listener;
    private Logger log;

    public static FileWatchingManager create(@Nonnull FileChangedListener listener) {
        FileWatchingManager result = new FileWatchingManager(listener);
        result.init();
        return result;
    }

    private FileWatchingManager(@Nonnull FileChangedListener listener) {
        this.listener = listener;
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.configInfos = Maps.newHashMap();
            this.watchThread = new Thread(this::doWatch);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        this.watchThread.start();
    }

    public void registerDirectoryListener(File file, String configPrefix) {
        try {
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            ConfigInfo configInfo = this.configInfos.get(path);
            if (configInfo == null) {
                WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.configInfos.put(key, new ConfigInfo(path, configPrefix));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerDirectoryListener(File file) {
        this.registerDirectoryListener(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWatch() {
        Logger log = this.getLogger();
        log.info("Starting watch of folder configurations");
        while (this.runWatch) {
            try {
                WatchKey key;
                try {
                    key = this.watcher.take();
                }
                catch (InterruptedException ex) {
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (!this.runWatch) break;
                    if (event == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent.Kind<Path> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path name = (Path)ev.context();
                    ConfigInfo configInfo = this.configInfos.get(key);
                    long now = System.nanoTime();
                    Path targetPath = configInfo.path.resolve(name);
                    File target = targetPath.toFile();
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.listener.fileChanged(target, configInfo.configPrefix, kind, now);
                        continue;
                    }
                    if (!target.exists() || target.length() <= 0L) continue;
                    this.listener.fileChanged(target, configInfo.configPrefix, kind, now);
                }
                if (this.runWatch) {
                    boolean valid = key.reset();
                    if (valid) continue;
                    log.error("Fatal error can't synchronize between Artifactory Config files");
                    return;
                }
                break;
            }
            catch (ClosedWatchServiceException e) {
                if (this.runWatch) {
                    log.error("Watch service was closed for synchronize between Artifactory Config files due to: " + e.getMessage(), (Throwable)e);
                    continue;
                }
                log.info("Watch service ended on destroy");
            }
            catch (Exception e) {
                log.error("Unknown exception while watching for file changes: " + e.getMessage(), (Throwable)e);
            }
        }
        log.info("End watch of folder configurations");
        Thread thread = this.watchThread;
        synchronized (thread) {
            this.watchThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.runWatch = false;
            this.watcher.close();
            Thread thread = this.watchThread;
            synchronized (thread) {
                this.watchThread.wait(1000L);
            }
        }
        catch (Exception e) {
            String msg = "Watch service could not be closed smoothly due to: " + e.getMessage();
            if (this.log != null) {
                this.log.error(msg, (Throwable)e);
            }
            System.err.println(msg);
            e.printStackTrace();
        }
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(FileWatchingManager.class);
        }
        return this.log;
    }

    static class ConfigInfo {
        final Path path;
        final String configPrefix;

        public ConfigInfo(Path path, String configPrefix) {
            this.path = path;
            this.configPrefix = configPrefix;
        }
    }
}

