/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.service;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;
import org.jfrog.common.ClockUtils;
import org.jfrog.common.YamlUtils;
import org.jfrog.common.config.diff.DiffFunctions;
import org.jfrog.common.config.diff.DiffUtils;
import org.jfrog.config.bean.Configuration;
import org.jfrog.config.bean.mutable.MutableConfiguration;
import org.jfrog.config.service.ConfigurationKey;
import org.jfrog.config.service.ConfigurationStorageService;
import org.jfrog.config.service.InternalConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalConfigurationServiceBase<T extends Configuration, M extends MutableConfiguration, I extends M>
implements InternalConfigurationService<T, M> {
    private final Map<String, EventBus> eventBuses;
    private final ConfigurationStorageService<T> configurationStorageService;
    protected final DiffFunctions diffFunctions;
    private final Class<I> implClass;
    protected final YamlUtils yamlUtils;
    private I configuration;
    protected static final Logger log = LoggerFactory.getLogger(InternalConfigurationServiceBase.class);

    public InternalConfigurationServiceBase(ConfigurationStorageService<T> configurationStorageService, YamlUtils yamlUtils, DiffFunctions diffFunctions, Class<I> implClass) {
        this.configurationStorageService = configurationStorageService;
        this.diffFunctions = diffFunctions;
        this.implClass = implClass;
        this.eventBuses = new HashMap<String, EventBus>();
        this.yamlUtils = yamlUtils;
    }

    @Override
    public void initializeConfiguration() {
        if (!this.importFromFile() && !this.reloadFromDb()) {
            this.importDefaultConfiguration();
        }
        this.patchFromFile();
        this.overrideFromSecretFile();
    }

    private void overrideFromSecretFile() {
        File configSecretFile = this.getConfigSecretFile();
        if (configSecretFile != null && configSecretFile.exists()) {
            log.debug("Configuration secret file exists. Loading...");
            MutableConfiguration clonedConfiguration = (MutableConfiguration)this.yamlUtils.clone(this.configuration, this.implClass);
            MutableConfiguration secretConfiguration = (MutableConfiguration)this.yamlUtils.readValue(configSecretFile, this.implClass);
            if (secretConfiguration != null) {
                secretConfiguration.clearSecretSystemProperties();
                clonedConfiguration.overrideSecretPropertyValues(secretConfiguration);
                this.findDiffAndNotifyListener(clonedConfiguration);
                log.info("Loading from configuration secret file finished successfully");
            } else {
                log.info("Ignored empty configuration secret file.");
            }
            try {
                FileUtils.forceDelete((File)configSecretFile);
            }
            catch (IOException e) {
                log.error("Could not delete configuration secret file.", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
    }

    private boolean importFromFile() {
        return this.processFile(this.getConfigImportFile(), this::updateConfiguration, "Import");
    }

    private boolean patchFromFile() {
        return this.processFile(this.getConfigPatchFile(), this.getPatchProcessor(), "Patch");
    }

    private boolean processFile(File configFile, PatchProcessor process, String label) {
        if (configFile != null && configFile.exists()) {
            log.debug("{} file {} exists. Loading...", (Object)label, (Object)configFile.getAbsolutePath());
            if (process != null) {
                process.process(configFile);
            }
            this.deleteLastConfigImportFile(configFile);
            log.info("Loading from {} file {} finished successfully", (Object)label, (Object)configFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract File getConfigSecretFile();

    protected abstract File getConfigImportFile();

    protected abstract File getConfigPatchFile();

    protected abstract File getConfigLatestFile();

    protected PatchProcessor getPatchProcessor() {
        log.debug("getPatchProcessor Not implemented - ignoring");
        return null;
    }

    protected abstract void publishEvent(long var1);

    private void deleteLastConfigImportFile(File configFile) {
        FileUtils.deleteQuietly((File)configFile);
    }

    @Override
    public void saveCurrentConfigurationToFile() throws IOException {
        T currentConfiguration = this.getConfiguration();
        T encryptedConfiguration = currentConfiguration.isEncrypted() ? currentConfiguration : this.getWithEncryptedSecretProperties(currentConfiguration);
        this.saveConfigurationToFile(encryptedConfiguration);
    }

    private void saveConfigurationToFile(T newConfiguration) throws IOException {
        File configLatestFile = this.getConfigLatestFile();
        if (configLatestFile != null) {
            org.jfrog.common.FileUtils.writeContentToRollingFile((String)this.yamlUtils.valueToString(newConfiguration), (File)configLatestFile, (int)newConfiguration.getMaxConfigFilesToRetain());
        }
    }

    private void importDefaultConfiguration() {
        this.configuration = this.newDefaultInstance();
    }

    protected abstract I newDefaultInstance();

    @Override
    public boolean reloadFromDb() {
        log.debug("Loading configuration data from db");
        Optional<T> dbConfig = this.configurationStorageService.findConfig();
        if (dbConfig.isPresent()) {
            this.findDiffAndNotifyListener((Configuration)dbConfig.get());
            log.info("Loading configuration from db finished successfully");
            return true;
        }
        log.info("Configuration data wasn't found in db. Loading defaults");
        return false;
    }

    @Override
    public void updateConfiguration(File configFile) {
        Configuration value = (Configuration)this.yamlUtils.readValue(configFile, this.implClass);
        this.updateConfiguration(value);
    }

    @Override
    public void updateConfiguration(T newConfiguration) {
        this.findDiffAndNotifyListener(newConfiguration);
        long timestampToUpdate = ClockUtils.epochMillis();
        T encryptedConfiguration = newConfiguration.isEncrypted() ? newConfiguration : this.getWithEncryptedSecretProperties(newConfiguration);
        this.configurationStorageService.saveConfig(encryptedConfiguration);
        try {
            this.saveConfigurationToFile(encryptedConfiguration);
        }
        catch (IOException e) {
            log.warn("Could not save last configuration change to a file", (Throwable)e);
        }
        this.publishEvent(timestampToUpdate);
    }

    protected abstract T getWithEncryptedSecretProperties(T var1);

    protected abstract T getWithDecryptedSecretProperties(T var1);

    private void findDiffAndNotifyListener(T newConfiguration) {
        Object oldConfiguration = this.configuration;
        if (!this.implClass.isInstance(newConfiguration)) {
            throw new IllegalArgumentException("Unknown implementation of Configuration.");
        }
        Object decryptedNewConfiguration = newConfiguration.isEncrypted() ? this.getWithDecryptedSecretProperties(newConfiguration) : newConfiguration;
        this.configuration = (MutableConfiguration)decryptedNewConfiguration;
        if (oldConfiguration != null) {
            DiffResult changes = this.diffFunctions.diffFor(this.implClass, oldConfiguration, this.configuration);
            log.debug("Updating configuration data. Count of data differences {}", (Object)changes.getDiffs().size());
            DiffUtils.notifyHierarchicalEventBusIfPresent(this.eventBuses, (DiffResult)changes, diffList -> new InternalConfigurationService.ConfigurationDiffResult<Configuration>((Configuration)oldConfiguration, (Configuration)newConfiguration, (Collection<Diff<?>>)diffList));
        }
    }

    @Override
    public InternalConfigurationService.ConfigurationListener<T> register(ConfigurationKey key, Consumer<InternalConfigurationService.ConfigurationDiffResult<T>> onChange) {
        ConfigurationListenerImpl<T> configurationListener = new ConfigurationListenerImpl<T>(onChange);
        this.eventBuses.computeIfAbsent(key.getKey(), EventBus::new).register(configurationListener);
        return configurationListener;
    }

    @Override
    public InternalConfigurationService.ConfigurationListener<T> registerAndExecute(ConfigurationKey key, Consumer<InternalConfigurationService.ConfigurationDiffResult<T>> onChange) {
        onChange.accept(new InternalConfigurationService.ConfigurationDiffResult<Object>(null, this.getConfiguration(), (Collection<Diff<?>>)Collections.emptyList()));
        return this.register(key, onChange);
    }

    @Override
    public void unregister(ConfigurationKey key, InternalConfigurationService.ConfigurationListener unregisterWith) {
        this.eventBuses.computeIfPresent(key.getKey(), (k, value) -> {
            value.unregister((Object)unregisterWith);
            return value;
        });
    }

    @Override
    public T getConfiguration() {
        return (T)this.configuration;
    }

    @Override
    public M cloneMutableConfiguration() {
        return (M)((MutableConfiguration)this.yamlUtils.clone(this.configuration, this.implClass));
    }

    private static class ConfigurationListenerImpl<T extends Configuration>
    implements InternalConfigurationService.ConfigurationListener<T> {
        final Consumer<InternalConfigurationService.ConfigurationDiffResult<T>> consumer;

        ConfigurationListenerImpl(Consumer<InternalConfigurationService.ConfigurationDiffResult<T>> consumer) {
            this.consumer = consumer;
        }

        @Override
        @Subscribe
        public void onChange(InternalConfigurationService.ConfigurationDiffResult<T> diff) {
            this.consumer.accept(diff);
        }
    }

    @FunctionalInterface
    public static interface PatchProcessor {
        public void process(File var1);
    }
}

