/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.service;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.commons.lang3.builder.Diff;
import org.jfrog.common.config.diff.DiffFunctions;
import org.jfrog.config.bean.Configuration;
import org.jfrog.config.bean.mutable.MutableConfiguration;
import org.jfrog.config.service.ConfigurationKey;

public interface InternalConfigurationService<T extends Configuration, M extends MutableConfiguration> {
    public void initializeConfiguration();

    public boolean reloadFromDb();

    public void updateConfiguration(T var1);

    public void saveCurrentConfigurationToFile() throws IOException;

    public ConfigurationListener<T> register(ConfigurationKey var1, Consumer<ConfigurationDiffResult<T>> var2);

    public ConfigurationListener<T> registerAndExecute(ConfigurationKey var1, Consumer<ConfigurationDiffResult<T>> var2);

    public void unregister(ConfigurationKey var1, ConfigurationListener<T> var2);

    public T getConfiguration();

    public M cloneMutableConfiguration();

    default public void mergeConfiguration(String yamlToMerge, DiffFunctions diffFunctions) {
    }

    public static final class ConfigurationDiffResult<T extends Configuration> {
        private final T oldConfiguration;
        private final T newConfiguration;
        private final Collection<Diff<?>> diffs;

        public ConfigurationDiffResult(T oldConfiguration, T newConfiguration, Collection<Diff<?>> diffs) {
            this.oldConfiguration = oldConfiguration;
            this.newConfiguration = newConfiguration;
            this.diffs = diffs;
        }

        public T getOldConfiguration() {
            return this.oldConfiguration;
        }

        public T getNewConfiguration() {
            return this.newConfiguration;
        }

        public Collection<Diff<?>> getDiffs() {
            return this.diffs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigurationDiffResult)) {
                return false;
            }
            ConfigurationDiffResult other = (ConfigurationDiffResult)o;
            T this$oldConfiguration = this.getOldConfiguration();
            T other$oldConfiguration = other.getOldConfiguration();
            if (this$oldConfiguration == null ? other$oldConfiguration != null : !this$oldConfiguration.equals(other$oldConfiguration)) {
                return false;
            }
            T this$newConfiguration = this.getNewConfiguration();
            T other$newConfiguration = other.getNewConfiguration();
            if (this$newConfiguration == null ? other$newConfiguration != null : !this$newConfiguration.equals(other$newConfiguration)) {
                return false;
            }
            Collection<Diff<?>> this$diffs = this.getDiffs();
            Collection<Diff<?>> other$diffs = other.getDiffs();
            return !(this$diffs == null ? other$diffs != null : !((Object)this$diffs).equals(other$diffs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $oldConfiguration = this.getOldConfiguration();
            result = result * 59 + ($oldConfiguration == null ? 43 : $oldConfiguration.hashCode());
            T $newConfiguration = this.getNewConfiguration();
            result = result * 59 + ($newConfiguration == null ? 43 : $newConfiguration.hashCode());
            Collection<Diff<?>> $diffs = this.getDiffs();
            result = result * 59 + ($diffs == null ? 43 : ((Object)$diffs).hashCode());
            return result;
        }

        public String toString() {
            return "InternalConfigurationService.ConfigurationDiffResult(oldConfiguration=" + this.getOldConfiguration() + ", newConfiguration=" + this.getNewConfiguration() + ", diffs=" + this.getDiffs() + ")";
        }
    }

    public static interface ConfigurationListener<T extends Configuration> {
        public void onChange(ConfigurationDiffResult<T> var1);
    }
}

