/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;
import org.jfrog.common.logging.BootstrapLogger;
import org.jfrog.config.LogChannel;

public class TemporaryLogChannel
implements LogChannel {
    private final boolean enableDebug;

    public TemporaryLogChannel(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    @Override
    public void debug(String msg) {
        if (this.enableDebug) {
            BootstrapLogger.info((String)msg);
        }
    }

    @Override
    public void debug(String msg, Exception e) {
        if (this.enableDebug) {
            try (StringWriter stack = new StringWriter();){
                e.printStackTrace(new PrintWriter(stack));
                this.debug(msg + ": " + stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void info(String msg) {
        BootstrapLogger.info((String)msg);
    }

    @Override
    public void warn(String msg) {
        BootstrapLogger.warn((String)msg);
    }

    @Override
    public void warn(String msg, Exception e) {
        this.logException(msg, e, this::warn);
    }

    @Override
    public void error(String msg) {
        BootstrapLogger.error((String)msg);
    }

    @Override
    public void error(String msg, Exception e) {
        this.logException(msg, e, this::error);
    }

    private void logException(String msg, Exception e, Consumer<String> log) {
        try (StringWriter stack = new StringWriter();){
            e.printStackTrace(new PrintWriter(stack));
            log.accept(msg + ": " + stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

