/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jfrog.config.DbChannel;
import org.jfrog.config.db.CommonDbProperties;
import org.jfrog.storage.DbType;
import org.jfrog.storage.util.DbStatementUtils;
import org.jfrog.storage.util.DbUtils;

public class TemporaryDBChannel
implements DbChannel {
    private final Driver driver;
    private final DbType dbType;
    private Connection conn = null;

    public TemporaryDBChannel(CommonDbProperties dbProperties) {
        try {
            String password = dbProperties.getPassword();
            String userName = dbProperties.getUsername();
            String url = dbProperties.getConnectionUrl();
            String driverClass = dbProperties.getDriverClass();
            Class<?> aClass = Class.forName(driverClass);
            this.driver = (Driver)aClass.newInstance();
            Properties info = new Properties();
            info.put("user", userName == null ? "" : userName);
            info.put("password", password == null ? "" : password);
            this.conn = this.driver.connect(url, info);
            this.conn.setAutoCommit(true);
            this.dbType = dbProperties.getDbType();
        }
        catch (Exception e) {
            throw new RuntimeException("Could't establish connection with db: " + dbProperties.getConnectionUrl(), e);
        }
    }

    @Override
    public ResultSet executeSelect(String query, Object ... params) throws SQLException {
        PreparedStatement preparedStatement;
        if (params == null || params.length == 0) {
            preparedStatement = this.conn.prepareStatement(query);
        } else {
            preparedStatement = this.conn.prepareStatement(DbStatementUtils.parseInListQuery((String)query, (Object[])params));
            DbStatementUtils.setParamsToStmt((PreparedStatement)preparedStatement, (Object[])params);
        }
        return preparedStatement.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String query, Object ... params) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            if (params == null || params.length == 0) {
                preparedStatement = this.conn.prepareStatement(query);
            } else {
                preparedStatement = this.conn.prepareStatement(DbStatementUtils.parseInListQuery((String)query, (Object[])params));
                DbStatementUtils.setParamsToStmt((PreparedStatement)preparedStatement, (Object[])params);
            }
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            DbStatementUtils.close(preparedStatement);
            throw throwable;
        }
        DbStatementUtils.close((Statement)preparedStatement);
        return n;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public boolean isTableExists(String tableName) {
        try {
            return DbUtils.tableExists((DatabaseMetaData)this.conn.getMetaData(), (DbType)this.dbType, (String)tableName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not find database table " + tableName, e);
        }
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to close temporary DB channel connection", e);
        }
    }
}

