/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.jfrog.config.db.ConfigWithTimestamp;
import org.jfrog.config.utils.TimeProvider;

public class FileConfigWithTimestamp
implements ConfigWithTimestamp {
    private File file;
    private TimeProvider timeProvider;

    public FileConfigWithTimestamp(File file, TimeProvider timeProvider) {
        this.file = file;
        this.timeProvider = timeProvider;
    }

    @Override
    public InputStream getBinaryStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long getTimestamp() {
        return this.timeProvider.getNormalizedTime(this.file.lastModified());
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public boolean isAfter(ConfigWithTimestamp config) {
        return config == null || this.getTimestamp() > config.getTimestamp() && this.getTimestamp() - config.getTimestamp() > 1000L;
    }

    @Override
    public boolean isAfter(Long timestamp) {
        return timestamp == null || this.getTimestamp() > timestamp && this.getTimestamp() - timestamp > 1000L;
    }

    @Override
    public boolean isBefore(@Nullable ConfigWithTimestamp config) {
        return config == null || this.isBefore(config.getTimestamp());
    }

    @Override
    public boolean isBefore(@Nullable Long timestamp) {
        return timestamp == null || this.getTimestamp() < timestamp && this.getTimestamp() - timestamp < -1000L;
    }

    public File getFile() {
        return this.file;
    }

    public long getLength() {
        return this.file.length();
    }
}

