/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config.db;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jfrog.config.db.ConfigWithTimestamp;

public class DBConfigWithTimestamp
implements ConfigWithTimestamp {
    private byte[] content;
    private long timestamp;
    private String name;

    public DBConfigWithTimestamp(byte[] content, long timestamp, String name) {
        this.content = content;
        this.timestamp = timestamp;
        this.name = name;
    }

    @Override
    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("DBConfigWithTimestamp doesn't support the 'getSize()' method");
    }

    @Override
    public boolean isBefore(ConfigWithTimestamp config) {
        return config == null || this.timestamp < config.getTimestamp();
    }

    @Override
    public boolean isBefore(Long timestamp) {
        return timestamp == null || this.timestamp < timestamp;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAfter(ConfigWithTimestamp config) {
        return config == null || this.timestamp > config.getTimestamp();
    }

    @Override
    public boolean isAfter(Long timestamp) {
        return timestamp == null || this.timestamp > timestamp;
    }
}

