/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config;

import java.sql.ResultSet;
import org.jfrog.config.DbChannel;
import org.jfrog.storage.DbType;

public class DbTimestampHelper {
    public static String getCurrentTimestampQueryForDbType(DbType dbType) {
        String query;
        switch (dbType) {
            case MYSQL: 
            case POSTGRESQL: 
            case MSSQL: 
            case MARIADB: {
                query = "SELECT CURRENT_TIMESTAMP";
                break;
            }
            case ORACLE: {
                query = "SELECT CURRENT_TIMESTAMP FROM DUAL";
                break;
            }
            case DERBY: {
                query = "SELECT CURRENT_TIMESTAMP FROM SYSIBM.SYSDUMMY1";
                break;
            }
            default: {
                throw new RuntimeException("Invalid database type: " + dbType + " expecting one of the following:  DERBY, MYSQL, MARIADB, ORACLE, MSSQL, POSTGRESQL");
            }
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getCurrentDbTime(DbChannel dbChannel) {
        String query = DbTimestampHelper.getCurrentTimestampQueryForDbType(dbChannel.getDbType());
        try (ResultSet resultSet = dbChannel.executeSelect(query, new Object[0]);){
            if (!resultSet.next()) return 0L;
            long l = resultSet.getTimestamp(1).getTime();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch current time from the database", e);
        }
    }

    public static long getTimeGapBetweenServerAndDb(DbChannel dbChannel) {
        long dbTime = DbTimestampHelper.getCurrentDbTime(dbChannel);
        return dbTime > 0L ? System.currentTimeMillis() - dbTime : 0L;
    }

    public static long getAdjustedCurrentTimestamp(DbChannel dbChannel) {
        long timeGapBetweenServerAndDb = DbTimestampHelper.getTimeGapBetweenServerAndDb(dbChannel);
        return System.currentTimeMillis() - timeGapBetweenServerAndDb;
    }
}

