/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.config;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.jfrog.config.ConfigurationManagerInternal;
import org.jfrog.config.DbChannel;
import org.jfrog.config.Home;
import org.jfrog.config.LogChannel;
import org.jfrog.config.db.ConfigUpdateException;
import org.jfrog.config.db.ConfigWithTimestamp;
import org.jfrog.config.db.DBConfigWithTimestamp;
import org.jfrog.config.db.FileConfigWithTimestamp;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.storage.wrapper.BlobWrapper;

public class ConfigsDataAccessObject {
    private boolean tableExists = false;
    private final Object tableExistLock = new Object();
    private static final String COLUMN_LAST_MODIFIED = "last_modified";
    private static final String COLUMN_CONFIG_NAME = "config_name";
    private static final String COLUMN_DATA = "data";
    private static final String CONFIG_EXISTS = "SELECT COUNT(1) FROM configs WHERE config_name = ?";
    private static final String GET_CONFIG = "SELECT * FROM configs WHERE config_name = ?";
    private static final String GET_CONFIGS_BY_PREFIX = "SELECT * FROM configs WHERE config_name LIKE ?";
    private static final String GET_CONFIG_TIMESTAMP = "SELECT last_modified FROM configs WHERE config_name = ?";
    private static final String INSERT_CONFIG = "INSERT INTO configs (config_name, last_modified, data) VALUES(?, ?, ?)";
    private static final String UPDATE_CONFIG = "UPDATE configs SET last_modified = ?, data = ? WHERE config_name = ?";
    private ConfigurationManagerInternal configurationManager;

    public ConfigsDataAccessObject(ConfigurationManagerInternal configurationManager) {
        this.configurationManager = configurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigsTableExist() {
        if (!this.tableExists) {
            Object object = this.tableExistLock;
            synchronized (object) {
                if (!this.tableExists) {
                    try {
                        this.tableExists = this.dbChannel().isTableExists("configs");
                    }
                    catch (Exception e) {
                        this.log().debug("Configs table doesn't exist: " + e.getMessage());
                        return false;
                    }
                }
            }
        }
        return this.tableExists;
    }

    public boolean hasConfig(String name) throws SQLException {
        try (ResultSet resultSet = this.dbChannel().executeSelect(CONFIG_EXISTS, name);){
            boolean bl = resultSet.next() && resultSet.getInt(1) > 0;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getConfigTimestamp(String name) {
        try (ResultSet resultSet = this.dbChannel().executeSelect(GET_CONFIG_TIMESTAMP, name);){
            if (!resultSet.next()) return null;
            Long l = resultSet.getLong(COLUMN_LAST_MODIFIED);
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve config timestamp from database for: " + name, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigWithTimestamp getConfig(String name, boolean encrypted, Home home) {
        try (ResultSet resultSet = this.dbChannel().executeSelect(GET_CONFIG, name);){
            if (!resultSet.next()) return null;
            long timestamp = resultSet.getLong(COLUMN_LAST_MODIFIED);
            String configName = resultSet.getString(COLUMN_CONFIG_NAME);
            byte[] content = this.getConfigContent(resultSet, encrypted, home);
            DBConfigWithTimestamp dBConfigWithTimestamp = new DBConfigWithTimestamp(content, timestamp, configName);
            return dBConfigWithTimestamp;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve config from database for: " + name, e);
        }
    }

    public List<DBConfigWithTimestamp> getConfigs(String prefix, boolean encrypted, Home home) {
        EncryptionWrapper masterWrapper;
        ArrayList result = Lists.newArrayList();
        if (encrypted) {
            masterWrapper = this.getMasterEncryptionWrapper(home);
            if (masterWrapper == null) {
                throw new RuntimeException("Tried pulling an encrypted config from the DB but no master.key file exists");
            }
        } else {
            masterWrapper = null;
        }
        try (ResultSet resultSet = this.dbChannel().executeSelect(GET_CONFIGS_BY_PREFIX, prefix + "%");){
            while (resultSet.next()) {
                long timestamp = resultSet.getLong(COLUMN_LAST_MODIFIED);
                String name = resultSet.getString(COLUMN_CONFIG_NAME);
                byte[] content = this.getConfigContent(resultSet, masterWrapper);
                result.add(new DBConfigWithTimestamp(content, timestamp, name));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch configs for prefix: " + prefix, e);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setConfig(String name, FileConfigWithTimestamp configWithTime, boolean encrypted, Home home) {
        int updatedRows;
        ByteArrayInputStream streamToDb = null;
        long timestamp = configWithTime.getTimestamp();
        try {
            byte[] configBytes;
            try (InputStream stream = configWithTime.getBinaryStream();){
                configBytes = IOUtils.toByteArray((InputStream)stream);
            }
            if (encrypted) {
                configBytes = this.encryptConfig(configBytes, home);
            }
            streamToDb = new ByteArrayInputStream(configBytes);
            BlobWrapper blobWrapper = new BlobWrapper((InputStream)streamToDb, (long)configBytes.length);
            if (this.hasConfig(name)) {
                this.log().debug("Updating database with config changes for " + name);
                updatedRows = this.dbChannel().executeUpdate(UPDATE_CONFIG, timestamp, blobWrapper, name);
            } else {
                try {
                    this.log().debug("Creating database config changes for " + name);
                    updatedRows = this.dbChannel().executeUpdate(INSERT_CONFIG, name, timestamp, blobWrapper);
                }
                catch (SQLException e) {
                    this.log().debug("Insert failed (optimistic), updating database config changes for " + name);
                    streamToDb = new ByteArrayInputStream(configBytes);
                    blobWrapper = new BlobWrapper((InputStream)streamToDb, (long)configBytes.length);
                    updatedRows = this.dbChannel().executeUpdate(UPDATE_CONFIG, timestamp, blobWrapper, name);
                }
            }
        }
        catch (SQLException se) {
            try {
                throw new ConfigUpdateException("Failed to insert/update config '" + name + "' to database.", se);
                catch (Exception e) {
                    throw new RuntimeException("Failed to insert/update config '" + name + "' to database.", e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(streamToDb);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)streamToDb);
        if (updatedRows <= 0) {
            this.log().debug("Update/Insert config '" + name + "' finished without an exception and without changes to the database.");
        }
    }

    public void setProtectedConfig(String name, FileConfigWithTimestamp configWithTime, boolean encrypted, Home home) {
        ByteArrayInputStream streamToDb = null;
        long timestamp = configWithTime.getTimestamp();
        try {
            byte[] configBytes;
            try (InputStream stream = configWithTime.getBinaryStream();){
                configBytes = IOUtils.toByteArray((InputStream)stream);
            }
            if (encrypted) {
                configBytes = this.encryptConfig(configBytes, home);
            }
            streamToDb = new ByteArrayInputStream(configBytes);
            BlobWrapper blobWrapper = new BlobWrapper((InputStream)streamToDb, (long)configBytes.length);
            String msg = "Insert failed (optimistic), updating database protected config changes for " + name;
            try {
                this.log().debug("Creating database protected config changes for " + name);
                int updatedRows = this.dbChannel().executeUpdate(INSERT_CONFIG, name, timestamp, blobWrapper);
                if (updatedRows != 1) {
                    this.log().debug(msg);
                    throw new RuntimeException(msg);
                }
            }
            catch (SQLException e) {
                this.log().debug(msg);
                throw new RuntimeException("Could not insert protected file " + name + " into the config table");
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to insert/update config '" + name + "' to database.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(streamToDb);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)streamToDb);
    }

    public boolean removeConfig(String name) {
        try {
            return this.dbChannel().executeUpdate("DELETE from configs WHERE config_name = ? ", name) > 0;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remove config for name: " + name, e);
        }
    }

    private byte[] getConfigContent(ResultSet resultSet, boolean encrypted, Home home) throws IOException, SQLException {
        if (encrypted) {
            EncryptionWrapper masterWrapper = this.getMasterEncryptionWrapper(home);
            if (masterWrapper == null) {
                throw new RuntimeException("Tried pulling an encrypted config from the DB but no master.key file exists");
            }
            return this.getConfigContent(resultSet, masterWrapper);
        }
        return this.getConfigContent(resultSet, null);
    }

    private EncryptionWrapper getMasterEncryptionWrapper(Home home) {
        try {
            return home.getMasterEncryptionWrapper();
        }
        catch (Exception e) {
            this.log().warn("Unable to load master.key, reason: " + e.getMessage());
            this.log().debug("Unable to load master.key", e);
            return null;
        }
    }

    private byte[] getConfigContent(ResultSet resultSet, @Nullable EncryptionWrapper masterWrapper) throws IOException, SQLException {
        byte[] content;
        try (InputStream data = resultSet.getBinaryStream(COLUMN_DATA);){
            content = IOUtils.toByteArray((InputStream)data);
        }
        return this.decryptConfigIfNeeded(content, masterWrapper);
    }

    private byte[] encryptConfig(byte[] configBytes, Home home) {
        byte[] encrypted = configBytes;
        EncryptionWrapper masterEncryptionWrapper = this.getMasterEncryptionWrapper(home);
        if (masterEncryptionWrapper != null) {
            byte[] encryptedBytes = masterEncryptionWrapper.encrypt(configBytes);
            encrypted = masterEncryptionWrapper.getEncodingType().encode(encryptedBytes).getBytes(Charsets.UTF_8);
        }
        return encrypted;
    }

    private byte[] decryptConfigIfNeeded(@Nullable byte[] content, @Nullable EncryptionWrapper communicationKeyWrapper) {
        byte[] decrypted = content;
        if (content != null && communicationKeyWrapper != null) {
            decrypted = communicationKeyWrapper.decryptIfNeeded(new String(content, Charsets.UTF_8)).getDecryptedData().getBytes(Charsets.UTF_8);
        }
        return decrypted;
    }

    private DbChannel dbChannel() {
        return this.configurationManager.getAdapter().getDbChannel();
    }

    private LogChannel log() {
        return this.configurationManager.getAdapter().getLogChannel();
    }
}

