package org.jfrog.config.wrappers;

import java.io.File;

/**
 * @author gidis
 */
public class SharedConfigMetadata {
    private File file;
    private String configName;
    private String defaultContent;
    private boolean mandatory;
    private boolean encrypted;
    private boolean protectedConfig;
    private ConfigCallback configCallback;


    public SharedConfigMetadata(File file, String configName,boolean mandatory) {
        this(file,configName,null,mandatory,false,false,null);
    }


    public SharedConfigMetadata(File file, String configName, String defaultContent, boolean mandatory,
                                boolean encrypted, boolean protectedConfig,ConfigCallback configCallback) {
        this.file = file;
        this.configName = configName;
        this.defaultContent = defaultContent;
        this.mandatory = mandatory;
        this.encrypted = encrypted;
        this.protectedConfig = protectedConfig;
        this.configCallback = configCallback;

    }

    public SharedConfigMetadata(File file, String configName, String defaultContent, boolean mandatory,
                                boolean encrypted, boolean protectedConfig) {
        this(file,configName,defaultContent,mandatory,encrypted,protectedConfig,null);
    }



    public File getFile() {
        return file;
    }

    public String getConfigName() {
        return configName;
    }

    public String getDefaultContent() {
        return defaultContent;
    }

    public boolean isMandatory() {
        return mandatory;
    }

    public boolean isEncrypted() {
        return encrypted;
    }

    public boolean isProtectedConfig() {
        return protectedConfig;
    }

    public ConfigCallback getConfigCallback() {
        return configCallback;
    }
}
