package org.jfrog.config.wrappers;

import org.apache.commons.io.FileUtils;
import org.jfrog.config.Home;

import java.io.File;
import java.io.IOException;
import java.net.URL;

/**
 * @author gidis
 */
public class MetaInfFile implements DefaultFileProvider {
    private String defaultContent;
    private File file;

    public MetaInfFile(String defaultContent, File file) {
        this.defaultContent = defaultContent;
        this.file = file;
    }

    @Override
    public void create() {
        try {
            if (file.exists()) {
                return;
            }
            //Copy from default
            URL url = Home.class.getResource(defaultContent);
            if (url == null) {
                throw new RuntimeException("Could not read classpath resource '" + defaultContent + "'.");
            }
            FileUtils.copyURLToFile(url, file);
            boolean success = file.setLastModified(System.currentTimeMillis());
            if (!success) {
                throw new RuntimeException(
                        "Failed to modify the Last modification time for file: " + file.getAbsolutePath());
            }
        } catch (IOException e) {
            throw new RuntimeException("Could not create the default '" + defaultContent + "' at '"
                    + file.getAbsolutePath() + "'.", e);
        }
    }
}
