package org.jfrog.config.wrappers;

import org.jfrog.config.BroadcastChannel;
import org.jfrog.config.DbChannel;
import org.jfrog.config.Home;
import org.jfrog.config.LogChannel;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gidis
 */
public interface ConfigurationManagerAdapter {
    void setPermanentLogChannel();

    void setPermanentBroadcastChannel(BroadcastChannel broadcastChannel);

    void setPermanentDBChannel(DbChannel permanentDbChannel);

    DbChannel getDbChannel();

    LogChannel getLogChannel();

    BroadcastChannel getBroadcastChannel();

    void destroy();

    int getRetryAmount();

    boolean allowDbUpdate();

    String getName();

    void initialize();

    List<String> getBlackListConfigs();

    List<MetaInfFile> getDefaultConfigs();

    List<SharedConfigMetadata> getSharedConfigs();

    List<SharedFolderMetadata> getSharedFolders();

    Home getHome();

    void unbind();

    void bind();

    static String normalizedFilesystemPath(String... parts) {
        return Arrays.stream(parts).collect(Collectors.joining(File.separator));
    }

}
