package org.jfrog.config.log;

import org.jfrog.common.logging.BootstrapLogger;
import org.jfrog.config.LogChannel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;

/**
 * @author gidis
 */
public class TemporaryLogChannel implements LogChannel {

    private final boolean enableDebug;

    public TemporaryLogChannel(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    @Override
    public void debug(String msg) {
        if (enableDebug) {
            //Did you expect this to magically be something else?
            BootstrapLogger.info(msg);
        }
    }

    @Override
    public void debug(String msg, Exception e) {
        if (enableDebug) {
            try (StringWriter stack = new StringWriter()) {
                e.printStackTrace(new PrintWriter(stack));
                debug(msg + ": " + stack);
            } catch (Exception ex) {
                //meh.
            }
        }
    }

    @Override
    public void info(String msg) {
        BootstrapLogger.info(msg);
    }

    @Override
    public void warn(String msg) {
        BootstrapLogger.warn(msg);
    }

    @Override
    public void warn(String msg, Exception e) {
        logException(msg, e, this::warn);
    }

    @Override
    public void error(String msg) {
        BootstrapLogger.error(msg);
    }

    @Override
    public void error(String msg, Exception e) {
        logException(msg, e, this::error);
    }

    private void logException(String msg, Exception e, Consumer<String> log) {
        try (StringWriter stack = new StringWriter()) {
            e.printStackTrace(new PrintWriter(stack));
            log.accept(msg + ": " + stack);
        } catch (Exception ex) {
            //meh.
        }
    }
}
