package org.jfrog.config.db;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * @author gidis
 */
public class DBConfigWithTimestamp implements ConfigWithTimestamp {

    private byte[] content;
    private long timestamp;
    private String name;

    public DBConfigWithTimestamp(byte[] content, long timestamp, String name) {
        this.content = content;
        this.timestamp = timestamp;
        this.name = name;
    }

    @Override
    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(content);
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("DBConfigWithTimestamp doesn't support the 'getSize()' method");
    }

    @Override
    public boolean isBefore(ConfigWithTimestamp config) {
        // When (other == null) it's both before() and after() me, which is really fuzzy, current logic seems to support it but this is very risky
        return config == null || timestamp < config.getTimestamp();
    }

    @Override
    public boolean isBefore(Long timestamp) {
        return timestamp == null || this.timestamp < timestamp;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean isAfter(ConfigWithTimestamp config) {
        return config == null || timestamp > config.getTimestamp();
    }

    @Override
    public boolean isAfter(Long timestamp) {
        // When (other == null) it's both before() and after() me, which is really fuzzy, current logic seems to support it but this is very risky
        return timestamp == null || this.timestamp > timestamp;
    }
}
