package org.jfrog.config.bean;

import javax.annotation.Nonnull;
import java.util.function.Function;

/**
 * @author Noam Shemesh
 */
public interface Configuration {
    int getSchemaVersion();

    int getMaxConfigFilesToRetain();

    default ConfigProxy getProxy() {
        return null;
    }

    /**
     * Clear all system properties relating to secret property values contained in this Configuration object.
     */
    void clearSecretSystemProperties();

    /**
     * Overrides the secret property values of this object by those of the passed Configuration object.
     * @param secretConfiguration the configuration holding secret values to override with.
     */
    void overrideSecretPropertyValues(@Nonnull Configuration secretConfiguration);

    /**
     * Encrypt all secret property values of this Configuration object.
     * @param masterKeyEncryptor encryption function to be used, should use the master key.
     */
    void encryptSecretProperties(@Nonnull Function<String, String> masterKeyEncryptor);

    /**
     * Decrypt all secret property values of this Configuration object.
     * @param masterKeyDecryptor decryption function to be used, should use the master key.
     */
    void decryptSecretProperties(@Nonnull Function<String, String> masterKeyDecryptor);

    /**
     * Determines if this object is encrypted or not.
     * @return true if encrypted, false otherwise
     */
    boolean isEncrypted();
}
