package org.jfrog.config;

import org.jfrog.config.wrappers.FileEventType;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

/**
 * @author gidis
 */
public interface ConfigurationManager {

    void initDbProperties();

    void initDefaultFiles();

    void startSync();

    void forceFileChanged(File file, String configPrefix, FileEventType eventType) throws SQLException, IOException;

    void destroy();

    void setPermanentLogChannel();

    void setPermanentDBChannel(DbChannel dbChannelService);

    void remoteConfigChanged(String name, FileEventType fileEventType) throws Exception;

    void setPermanentBroadcastChannel(BroadcastChannel broadcastChannel);

    /**
     * get Db channel. Should not be called before the home converters
     *
     * @return dbchannel object
     */
    DbChannel getDBChannel();

    LogChannel getLogChannel();
}
