/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.sysconf;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.jfrog.sysconf.exception.SystemConfigurationException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;

class SysYamlSource {
    private final Map<String, String> props = Maps.newHashMap();

    SysYamlSource(@Nullable InputStream sysYamlStream) {
        try {
            this.load(sysYamlStream);
        }
        catch (ParserException e) {
            throw new SystemConfigurationException("Failed parsing system configuration file", e);
        }
    }

    @Nullable
    String get(@Nonnull String key) {
        return this.props.get(key);
    }

    Map<String, String> getProps() {
        return this.props;
    }

    private void load(InputStream is) {
        if (is != null) {
            try {
                Object yaml = new Yaml().load(is);
                this.process(yaml, "");
            }
            finally {
                Closeables.closeQuietly((InputStream)is);
            }
        }
    }

    private void process(Object yaml, String prefix) {
        if (yaml instanceof Map) {
            ((Map)yaml).forEach((k, v) -> this.process(v, this.buildPrefix(prefix, (String)k)));
        } else {
            this.props.put(prefix, this.buildValue(yaml));
        }
    }

    private String buildPrefix(String prefix, String key) {
        return "".equals(prefix) ? key : prefix + "." + key;
    }

    private String buildValue(Object value) {
        return value == null ? "" : "" + value;
    }
}

