/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.sysconf;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SysPropsSource {
    static final String SYS_PROP_PREFIX = "jf.";
    private final Map<String, String> jfrogSysProps = Maps.newHashMap();

    SysPropsSource() {
        this(System.getProperties());
    }

    SysPropsSource(Properties sysProps) {
        this.collectAllSystemPropertiesWithJfrogPrefix(sysProps);
    }

    @Nullable
    String get(@Nonnull String key) {
        return this.jfrogSysProps.get(SysPropsSource.toSysPropsKey(key));
    }

    static String toSysPropsKey(String key) {
        return SYS_PROP_PREFIX + key;
    }

    private void collectAllSystemPropertiesWithJfrogPrefix(Properties sysProps) {
        sysProps.stringPropertyNames().stream().filter(k -> k.startsWith(SYS_PROP_PREFIX)).forEach(k -> this.jfrogSysProps.put((String)k, sysProps.getProperty((String)k)));
    }
}

