/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.sysconf;

import java.io.File;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SysLayout {
    private static final String APP_DIR = "app";
    public static final String VAR_DIR = "var";
    public static final String ETC_DIR = "etc";
    public static final String SECURITY_DIR = "security";
    public static final String LOG_DIR = "log";
    public static final String BACKUP_DIR = "backup";
    public static final String WORK_DIR = "work";
    public static final String IMPORT_DIR = "import";
    public static final String DATA_DIR = "data";
    public static final String BOOTSTRAP_DIR = "bootstrap";
    public static final String ACCESS_DIR = "access";
    private final String serviceName;
    private final File home;
    private final File var;

    public SysLayout(File home, String serviceName) {
        Objects.requireNonNull(home, "Home dir must be provided for the system layout");
        this.assertServiceNameNotBlank(serviceName);
        this.serviceName = serviceName;
        this.home = home.getAbsoluteFile();
        this.var = new File(home, VAR_DIR);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public File getHomeDir() {
        return this.home;
    }

    public File getProductVar() {
        return this.var;
    }

    public File getProductApp() {
        return new File(this.home, APP_DIR);
    }

    public File getProductEtc() {
        return new File(this.getProductVar(), ETC_DIR);
    }

    public File getProductEtcSecurity() {
        return new File(this.getProductEtc(), SECURITY_DIR);
    }

    public File getProductBootstrap() {
        return new File(this.getProductVar(), BOOTSTRAP_DIR);
    }

    public File getProductBootstrapAccess() {
        return new File(this.getProductBootstrap(), ACCESS_DIR);
    }

    public File getProductBootstrapAccessEtc() {
        return new File(this.getProductBootstrapAccess(), ETC_DIR);
    }

    public File getProductBootstrapAccessEtcSecurity() {
        return new File(this.getProductBootstrapAccessEtc(), SECURITY_DIR);
    }

    public File getServiceEtc() {
        return this.getServiceEtc(this.serviceName);
    }

    public File getServiceEtc(String otherServiceName) {
        return this.getServiceDir(otherServiceName, ETC_DIR);
    }

    public File getProductLog() {
        return new File(this.getProductVar(), LOG_DIR);
    }

    @Deprecated
    public File getServiceLog() {
        return this.getProductLog();
    }

    @Deprecated
    public File getServiceLog(String otherServiceName) {
        return this.getProductLog();
    }

    public File getServiceData() {
        return this.getServiceData(this.serviceName);
    }

    public File getServiceData(String otherServiceName) {
        return this.getServiceDir(otherServiceName, DATA_DIR);
    }

    public File getServiceBackup() {
        return this.getServiceBackup(this.serviceName);
    }

    public File getServiceBackup(String otherServiceName) {
        return this.getServiceDir(otherServiceName, BACKUP_DIR);
    }

    public File getServiceWork() {
        return this.getServiceWork(this.serviceName);
    }

    public File getServiceWork(String otherServiceName) {
        return this.getServiceDir(otherServiceName, WORK_DIR);
    }

    private File getServiceDir(String serviceName, String dirName) {
        this.assertServiceNameNotBlank(serviceName);
        return Paths.get(this.var.getAbsolutePath(), dirName, serviceName).toFile();
    }

    private void assertServiceNameNotBlank(String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new IllegalArgumentException("Service name cannot be empty: '" + serviceName + "'");
        }
    }
}

