/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.sysconf;

import com.jfrog.sysconf.JoinKeyData;
import com.jfrog.sysconf.SysConfig;
import com.jfrog.sysconf.SysLayout;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class SysConfigHelper {
    private final SysConfig config;
    private final SysLayout sysLayout;

    SysConfigHelper(SysConfig config, SysLayout sysLayout) {
        this.config = config;
        this.sysLayout = sysLayout;
    }

    public String getMasterKeyFile() {
        return this.getConfiguredMasterKeyFile().orElseGet(this::getDefaultMasterKeyFile);
    }

    public Optional<String> getMasterKey() {
        return this.clearEmptyChars(this.config.get("shared.security.masterKey").orElseGet(this::readMasterKeyFromFile));
    }

    public Optional<String> getJoinKey() {
        return this.clearEmptyChars(this.config.get("shared.security.joinKey").orElseGet(this::readJoinKeyFromFile));
    }

    public Optional<JoinKeyData> getJoinKeyData() {
        return this.getJoinKeyDataFromSystemYaml().or(this::getJoinKeyDataFromBootstrap).or(this::getJoinKeyDataFromFile);
    }

    private Optional<JoinKeyData> getJoinKeyDataFromSystemYaml() {
        return this.config.get("shared.security.joinKey").flatMap(this::clearEmptyChars).map(key -> JoinKeyData.builder().source("system resource").shouldVerify(true).key((String)key).build());
    }

    private Optional<? extends JoinKeyData> getJoinKeyDataFromFile() {
        return Optional.ofNullable(this.readJoinKeyFromFile()).flatMap(this::clearEmptyChars).map(key -> JoinKeyData.builder().source(this.getJoinKeyFile()).shouldVerify(true).key((String)key).build());
    }

    private Optional<? extends JoinKeyData> getJoinKeyDataFromBootstrap() {
        String bootstrapJoinKeyFile = this.getBootstrapJoinKeyFile();
        return Optional.ofNullable(this.config.decrypt("shared.security.joinKey", this.fileToString(new File(bootstrapJoinKeyFile)))).flatMap(this::clearEmptyChars).map(key -> JoinKeyData.builder().source(bootstrapJoinKeyFile).shouldVerify(false).key((String)key).build());
    }

    public String getJoinKeyFile() {
        return this.getConfiguredJoinKeyFile().orElseGet(this::getDefaultJoinKeyFile);
    }

    public int getRouterExternalPort() {
        return this.config.getInt("router.entrypoints.externalPort", 8082);
    }

    public String getRouterUrl() {
        int port = this.config.getInt("router.entrypoints.internalPort", 8046);
        return "http://localhost:" + port;
    }

    public String getArtifactoryUrl() {
        return this.getRouterUrl() + "/artifactory";
    }

    public String getXrayUrl() {
        return this.getRouterUrl() + "/xray";
    }

    public String getDistributionUrl() {
        return this.getRouterUrl() + "/distribution";
    }

    public String getAccessUrl() {
        return this.getRouterUrl() + "/access";
    }

    public String getMetadataUrl() {
        return this.getRouterUrl() + "/metadata";
    }

    private Optional<String> getConfiguredMasterKeyFile() {
        return this.config.get("shared.security.masterKeyFile");
    }

    private String getDefaultMasterKeyFile() {
        return this.sysLayout.getProductEtcSecurity() + "/master.key";
    }

    private Optional<String> getConfiguredJoinKeyFile() {
        return this.config.get("shared.security.joinKeyFile");
    }

    public String getDefaultJoinKeyFile() {
        return this.sysLayout.getProductEtcSecurity() + "/join.key";
    }

    public String getBootstrapJoinKeyFile() {
        return this.sysLayout.getProductBootstrapAccessEtcSecurity() + "/join.key";
    }

    private String readJoinKeyFromFile() {
        return this.config.decrypt("shared.security.joinKey", this.fileToString(new File(this.getJoinKeyFile())));
    }

    private String readMasterKeyFromFile() {
        return this.fileToString(new File(this.getMasterKeyFile()));
    }

    private Optional<String> clearEmptyChars(String value) {
        return Optional.ofNullable(StringUtils.trimToNull((String)value));
    }

    private String fileToString(File file) {
        if (file.exists()) {
            try {
                return Files.readString(file.toPath());
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
        return null;
    }

    public long getBootstrapKeyReadTimeoutMs() {
        return TimeUnit.SECONDS.toMillis(this.config.getLong("shared.security.bootstrapKeysReadTimeoutSecs", 60L));
    }
}

