/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.sysconf;

import com.jfrog.sysconf.SysConfig;
import java.util.Optional;
import org.jfrog.security.crypto.EncodingType;
import org.jfrog.security.crypto.EncryptionWrapper;
import org.jfrog.security.crypto.EncryptionWrapperFactory;
import org.jfrog.security.crypto.JFrogMasterKeyEncrypter;
import org.jfrog.security.crypto.encoder.EncryptedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysConfigDecryptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SysConfigDecryptionHandler.class);
    private final SysConfig config;
    private EncryptionWrapper legacyEncrypter;
    private JFrogMasterKeyEncrypter masterEncrypter;

    SysConfigDecryptionHandler(SysConfig config) {
        this.config = config;
    }

    public String decrypt(String key, String value) {
        this.conditionallyInitEncrypters(key, value);
        if (this.isEncryptersConfigured()) {
            if (this.legacyEncrypter.isEncodedByMe(value)) {
                return this.legacyEncrypter.decryptIfNeeded(value).getDecryptedData();
            }
            if (this.masterEncrypter.isEncryptedByMe(value)) {
                return this.masterEncrypter.decrypt(value);
            }
        }
        return value;
    }

    public boolean isEncrypted(String value) {
        return EncodingType.MASTER_LEVEL.isEncodedByMe(value) || EncryptedString.isEncodedByMe((String)value);
    }

    void createEncryptersIfMasterKeyExist() {
        Optional<String> masterKey = this.config.helper().getMasterKey();
        if (masterKey.isPresent()) {
            this.legacyEncrypter = EncryptionWrapperFactory.aesKeyWrapperFromString((String)masterKey.get());
            this.masterEncrypter = new JFrogMasterKeyEncrypter(masterKey.get());
        }
    }

    private boolean isEncryptersConfigured() {
        return this.legacyEncrypter != null && this.masterEncrypter != null;
    }

    private void conditionallyInitEncrypters(String key, String value) {
        if (!this.isEncryptersConfigured() && this.isEncrypted(value)) {
            this.createEncryptersIfMasterKeyExist();
            if (!this.isEncryptersConfigured()) {
                log.warn("Encrypted key found for key '{}' but master.key is not configured", (Object)key);
            }
        }
    }
}

