/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.sysconf;

import com.google.common.collect.Maps;
import com.jfrog.sysconf.EnvVarsSource;
import com.jfrog.sysconf.MissingKeyException;
import com.jfrog.sysconf.SysConfigDecryptionHandler;
import com.jfrog.sysconf.SysConfigHelper;
import com.jfrog.sysconf.SysLayout;
import com.jfrog.sysconf.SysPropsSource;
import com.jfrog.sysconf.SysYamlSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class SysConfig {
    public static final String SYS_PROP_JF_PRODUCT_HOME = SysPropsSource.toSysPropsKey("product.home");
    private final SysPropsSource sysPropsSource = new SysPropsSource();
    private final EnvVarsSource envVarsSource;
    private final SysYamlSource yamlSource;
    private final Map<String, String> defaults;
    private final SysLayout sysLayout;
    private final SysConfigDecryptionHandler decryptionHandler;

    private SysConfig(String homeDirPath, InputStream sysYamlStream, Map<String, String> userDefaults, Map<String, String> testEnvVars) {
        this.envVarsSource = testEnvVars == null ? new EnvVarsSource() : new EnvVarsSource(testEnvVars);
        this.sysLayout = new SysLayout(SysConfig.getOrDetectAbsoluteHomeDir(homeDirPath, this.sysPropsSource, this.envVarsSource), "system");
        this.defaults = this.defensiveCopyOfDefaults(userDefaults);
        this.yamlSource = this.createYamlSource(sysYamlStream);
        this.decryptionHandler = new SysConfigDecryptionHandler(this);
    }

    public Optional<String> get(@Nonnull String key) {
        Objects.requireNonNull(key, "Config key cannot be null");
        String value = this.getFromNonDefaultSources(key);
        if (value == null) {
            value = this.getSharedFromNonDefaultSources(key);
        }
        if (value == null) {
            value = this.defaults.get(key);
        }
        if (value == null) {
            value = this.defaults.get(this.toSharedKey(key));
        }
        return Optional.ofNullable(this.decrypt(key, value));
    }

    public String get(String key, String defaultValue) {
        return this.get(key).orElse(defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        String result = this.get(key, String.valueOf(defaultValue));
        return Integer.parseInt(result);
    }

    public long getLong(String key, long defaultValue) {
        String result = this.get(key, String.valueOf(defaultValue));
        return Long.parseLong(result);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String result = this.get(key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(result);
    }

    public String getOrFail(String key) {
        return this.get(key).orElseThrow(() -> new MissingKeyException(key));
    }

    public SysConfigHelper helper() {
        return new SysConfigHelper(this, this.sysLayout);
    }

    private String getFromNonDefaultSources(@Nonnull String key) {
        String value = this.sysPropsSource.get(key);
        if (value != null) {
            return value;
        }
        value = this.envVarsSource.get(key);
        if (value != null) {
            return value;
        }
        return this.yamlSource.get(key);
    }

    String toSharedKey(String key) {
        int firstPartIndex = key.indexOf(46);
        return firstPartIndex > 0 ? "shared" + key.substring(firstPartIndex) : key;
    }

    public Path getHomeDir() {
        return this.sysLayout.getHomeDir().toPath();
    }

    private String getSharedFromNonDefaultSources(@Nonnull String key) {
        String sharedKey = this.toSharedKey(key);
        return sharedKey.equals(key) ? null : this.getFromNonDefaultSources(sharedKey);
    }

    private Map<String, String> defensiveCopyOfDefaults(Map<String, String> defaults) {
        return defaults == null ? Maps.newHashMap() : Maps.newHashMap(defaults);
    }

    private SysYamlSource createYamlSource(InputStream sysYamlStream) {
        if (sysYamlStream == null) {
            sysYamlStream = this.getSystemYamlFromDefaultLocation();
        }
        return new SysYamlSource(sysYamlStream);
    }

    private InputStream getSystemYamlFromDefaultLocation() {
        FileInputStream sysYamlStream = null;
        File systemYamlFile = new File(this.sysLayout.getProductEtc(), "system.yaml");
        if (systemYamlFile.exists()) {
            try {
                sysYamlStream = new FileInputStream(systemYamlFile);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }
        return sysYamlStream;
    }

    static Path detectJFrogProductHome(SysPropsSource propsSource, EnvVarsSource envSource) {
        String productHome = propsSource.get("product.home");
        if (productHome == null) {
            productHome = envSource.get("product.home");
        }
        if (productHome == null) {
            throw new IllegalStateException("Failed to create system config. JFrog product home wasn't supplied and couldn't be detected in environment variable '" + EnvVarsSource.toEnvVarKey("product.home") + "' or in system property '" + SysPropsSource.toSysPropsKey("product.home") + "'");
        }
        return Paths.get(productHome, new String[0]);
    }

    public static File detectAbsoluteHomeDir() {
        SysPropsSource sysPropsSource = new SysPropsSource();
        EnvVarsSource envVarsSource = new EnvVarsSource();
        return SysConfig.getOrDetectAbsoluteHomeDir(null, sysPropsSource, envVarsSource);
    }

    private static File getOrDetectAbsoluteHomeDir(String homeDir, SysPropsSource propsSource, EnvVarsSource envSource) {
        Path homeDirPath = homeDir == null ? SysConfig.detectJFrogProductHome(propsSource, envSource) : Paths.get(homeDir, new String[0]);
        return homeDirPath.toAbsolutePath().toFile();
    }

    String decrypt(String key, String value) {
        return this.decryptionHandler == null ? value : this.decryptionHandler.decrypt(key, value);
    }

    public static class Builder {
        private String homeDir;
        private InputStream sysYamlStream;
        private Map<String, String> defaults;
        private Map<String, String> testEnVars;

        public SysConfig build() {
            return new SysConfig(this.homeDir, this.sysYamlStream, this.defaults, this.testEnVars);
        }

        public Builder withHome(String jfrogProductHome) {
            this.homeDir = jfrogProductHome;
            return this;
        }

        public Builder withSystemYaml(InputStream is) {
            this.sysYamlStream = is;
            return this;
        }

        public Builder withSystemYaml(File systemYamlFile) {
            if (systemYamlFile.exists()) {
                try {
                    this.withSystemYaml(new FileInputStream(systemYamlFile));
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this;
        }

        public Builder withDefaults(Map<String, String> defaults) {
            this.defaults = defaults;
            return this;
        }

        public Builder withMockEnvVars(Map<String, String> envVars) {
            this.testEnVars = envVars;
            return this;
        }
    }
}

