/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.sysconf;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class EnvVarsSource {
    static final String ENV_VAR_PREFIX = "JF_";
    private final Map<String, String> jfrogEnvVars = Maps.newHashMap();

    EnvVarsSource() {
        this(System.getenv());
    }

    EnvVarsSource(Map<String, String> envVars) {
        this.collectAllEnvVarsWithJfrogPrefix(envVars);
    }

    @Nullable
    String get(@Nonnull String key) {
        return this.jfrogEnvVars.get(EnvVarsSource.toEnvVarKey(key));
    }

    static String toEnvVarKey(String key) {
        String envVarKey = key.replaceAll("\\.", "_");
        envVarKey = envVarKey.replaceAll("-", "");
        return ENV_VAR_PREFIX + envVarKey.toUpperCase();
    }

    private void collectAllEnvVarsWithJfrogPrefix(Map<String, String> envVars) {
        envVars.keySet().stream().filter(k -> k.startsWith(ENV_VAR_PREFIX)).forEach(k -> this.jfrogEnvVars.put((String)k, (String)envVars.get(k)));
    }
}

