package com.jfrog.sysconf;

/**
 * Constants of keys and values shared across multiple services.
 *
 * @author Yossi Shaul
 */
public interface SysConfigConstants {

    /**
     * jfrog product home directory
     */
    String KEY_JF_PRODUCT_HOME = "product.home";
    String ENV_JF_PRODUCT_HOME = EnvVarsSource.toEnvVarKey(KEY_JF_PRODUCT_HOME);
    String SYS_JF_PRODUCT_HOME = SysPropsSource.toSysPropsKey(KEY_JF_PRODUCT_HOME);

    /**
     * shared node id
     */
    String KEY_NODE_ID = "shared.node.id";
    String ENV_NODE_ID = EnvVarsSource.toEnvVarKey(KEY_NODE_ID);
    String SYS_NODE_ID = SysPropsSource.toSysPropsKey(KEY_NODE_ID);

    /**
     * node task affinity
     */
    String KEY_NODE_TASK_AFFINITY = "artifactory.node.taskAffinity";

    String KEY_MASTER_KEY = "shared.security.masterKey";
    String ENV_MASTER_KEY = EnvVarsSource.toEnvVarKey(KEY_MASTER_KEY);
    String KEY_MASTER_KEY_FILE = "shared.security.masterKeyFile";

    String KEY_JOIN_KEY = "shared.security.joinKey";
    String ENV_JOIN_KEY = EnvVarsSource.toEnvVarKey(KEY_JOIN_KEY);
    String SYS_JOIN_KEY = SysPropsSource.toSysPropsKey(KEY_JOIN_KEY);
    String KEY_JOIN_KEY_FILE = "shared.security.joinKeyFile";

    String KEY_BOOTSTRAP_KEY_READ_TIMEOUT = "shared.security.bootstrapKeysReadTimeoutSecs";
    long BOOTSTRAP_KEY_READ_TIMEOUT_DEFAULT = 60;

    String KEY_ROUTER_INTERNAL_PORT = "router.entrypoints.internalPort";
    String SYS_ROUTER_INTERNAL_PORT = SysPropsSource.toSysPropsKey(KEY_ROUTER_INTERNAL_PORT);
    String KEY_ROUTER_EXTERNAL_PORT = "router.entrypoints.externalPort";
    String KEY_ROUTER_ENABLED = "router.enabled"; // for the ITest infra
    String SYS_ROUTER_ENABLED = SysPropsSource.toSysPropsKey(KEY_ROUTER_ENABLED);
    int ROUTER_DEFAULT_INTERNAL_PORT = 8046;
    int ROUTER_DEFAULT_EXTERNAL_PORT = 8082;

    // Suffixes
    String ARTIFACTORY_SUFFIX = "/artifactory";
    String ACCESS_SUFFIX = "/access";
    String XRAY_SUFFIX = "/xray";
    String DISTRIBUTION_SUFFIX = "/distribution";
    String METADATA_SUFFIX = "/metadata";
}
