/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.rest.model.manifest;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jfrog.support.rest.model.Formats;

import java.time.ZonedDateTime;

/**
 * Model representing a support bundle, used for serializing the node-specific bundle manifest file.
 *
 * @author orid
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class NodeManifestBundleInfo {

    private String id;
    private String name;
    private String description;
    @JsonFormat(pattern = Formats.DATE_TIME_WITH_ZONE)
    private ZonedDateTime created;
    private String status;
}
