/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.rest.model.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.jfrog.support.rest.model.BundleCreationStatus;
import org.jfrog.support.rest.model.SupportBundleConfig;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ServiceManifest {
    private String serviceType;
    private String serviceId;
    private Map<String, Map<String, BundleCreationStatus>> microservices;
    private SupportBundleConfig bundleInfo;
    private BundleCreationStatus status;

    @JsonIgnore
    public BundleCreationStatus getMicroservicesAggregatedStatus() {
        if (this.microservices == null) {
            return BundleCreationStatus.IN_PROGRESS;
        }
        return this.microservices.values().stream().flatMap(map -> map.values().stream()).max(Comparator.comparing(ServiceManifest::getSeverity)).orElse(BundleCreationStatus.IN_PROGRESS);
    }

    private static int getSeverity(BundleCreationStatus status) {
        switch (Objects.requireNonNull(status)) {
            case SUCCESS: {
                return 0;
            }
            case IN_PROGRESS: {
                return 1;
            }
        }
        return 2;
    }

    public static ServiceManifestBuilder builder() {
        return new ServiceManifestBuilder();
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Map<String, Map<String, BundleCreationStatus>> getMicroservices() {
        return this.microservices;
    }

    public SupportBundleConfig getBundleInfo() {
        return this.bundleInfo;
    }

    public BundleCreationStatus getStatus() {
        return this.status;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setMicroservices(Map<String, Map<String, BundleCreationStatus>> microservices) {
        this.microservices = microservices;
    }

    public void setBundleInfo(SupportBundleConfig bundleInfo) {
        this.bundleInfo = bundleInfo;
    }

    public void setStatus(BundleCreationStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceManifest)) {
            return false;
        }
        ServiceManifest other = (ServiceManifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceType = this.getServiceType();
        String other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        Map<String, Map<String, BundleCreationStatus>> this$microservices = this.getMicroservices();
        Map<String, Map<String, BundleCreationStatus>> other$microservices = other.getMicroservices();
        if (this$microservices == null ? other$microservices != null : !((Object)this$microservices).equals(other$microservices)) {
            return false;
        }
        SupportBundleConfig this$bundleInfo = this.getBundleInfo();
        SupportBundleConfig other$bundleInfo = other.getBundleInfo();
        if (this$bundleInfo == null ? other$bundleInfo != null : !((Object)this$bundleInfo).equals(other$bundleInfo)) {
            return false;
        }
        BundleCreationStatus this$status = this.getStatus();
        BundleCreationStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceManifest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        Map<String, Map<String, BundleCreationStatus>> $microservices = this.getMicroservices();
        result = result * 59 + ($microservices == null ? 43 : ((Object)$microservices).hashCode());
        SupportBundleConfig $bundleInfo = this.getBundleInfo();
        result = result * 59 + ($bundleInfo == null ? 43 : ((Object)$bundleInfo).hashCode());
        BundleCreationStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceManifest(serviceType=" + this.getServiceType() + ", serviceId=" + this.getServiceId() + ", microservices=" + this.getMicroservices() + ", bundleInfo=" + this.getBundleInfo() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public ServiceManifest() {
    }

    public ServiceManifest(String serviceType, String serviceId, Map<String, Map<String, BundleCreationStatus>> microservices, SupportBundleConfig bundleInfo, BundleCreationStatus status) {
        this.serviceType = serviceType;
        this.serviceId = serviceId;
        this.microservices = microservices;
        this.bundleInfo = bundleInfo;
        this.status = status;
    }

    public static class ServiceManifestBuilder {
        private String serviceType;
        private String serviceId;
        private Map<String, Map<String, BundleCreationStatus>> microservices;
        private SupportBundleConfig bundleInfo;
        private BundleCreationStatus status;

        ServiceManifestBuilder() {
        }

        public ServiceManifestBuilder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public ServiceManifestBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public ServiceManifestBuilder microservices(Map<String, Map<String, BundleCreationStatus>> microservices) {
            this.microservices = microservices;
            return this;
        }

        public ServiceManifestBuilder bundleInfo(SupportBundleConfig bundleInfo) {
            this.bundleInfo = bundleInfo;
            return this;
        }

        public ServiceManifestBuilder status(BundleCreationStatus status) {
            this.status = status;
            return this;
        }

        public ServiceManifest build() {
            return new ServiceManifest(this.serviceType, this.serviceId, this.microservices, this.bundleInfo, this.status);
        }

        public String toString() {
            return "ServiceManifest.ServiceManifestBuilder(serviceType=" + this.serviceType + ", serviceId=" + this.serviceId + ", microservices=" + this.microservices + ", bundleInfo=" + this.bundleInfo + ", status=" + (Object)((Object)this.status) + ")";
        }
    }
}

