/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author orid
 */
public enum BundleCreationStatus {

    SUCCESS, IN_PROGRESS, FAILURE;

    @Override
    public String toString() {
        return toJson();
    }

    @JsonCreator
    public static BundleCreationStatus fromJson(String value) {
        if (value == null) {
            return null;
        }
        return valueOf(value.replace(' ', '_').toUpperCase());
    }

    @JsonValue
    public String toJson() {
        return name().toLowerCase().replace('_', ' ');
    }
}
