package org.jfrog.support.rest.model.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import lombok.experimental.UtilityClass;

@UtilityClass
public class JsonUtils {

    private static final ObjectMapper DEFAULT = configure(new ObjectMapper());

    /**
     * Configures a mapper with what is needed for JSON manifest files.
     */
    public static ObjectMapper configure(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return objectMapper;
    }

    /**
     * Gets the default mapper with minimal configuration for JSON manifest files.
     */
    public static ObjectMapper getDefaultObjectMapper() {
        return DEFAULT;
    }
}
