/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors.system.info;

import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import org.jfrog.support.common.core.collectors.system.info.BasePropInfoGroup;
import org.jfrog.support.common.core.collectors.system.info.InfoObject;

public class HostPropInfo
extends BasePropInfoGroup {
    private TreeMap<String, String> propertyMap;
    private OperatingSystemMXBean systemBean = ManagementFactory.getOperatingSystemMXBean();
    private MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();

    public HostPropInfo() {
        this.setPropertyMap();
    }

    private void setPropertyMap() {
        this.propertyMap = Maps.newTreeMap();
        this.propertyMap.put("os.arch", this.systemBean.getArch());
        this.propertyMap.put("os.name", this.systemBean.getName());
        this.propertyMap.put("os.version", this.systemBean.getVersion());
        this.propertyMap.put("Available Processors", Integer.toString(this.systemBean.getAvailableProcessors()));
        MemoryUsage heapMemoryUsage = this.memoryBean.getHeapMemoryUsage();
        this.propertyMap.put("Heap Memory Usage-Commited", Long.toString(heapMemoryUsage.getCommitted()));
        this.propertyMap.put("Heap Memory Usage-Init", Long.toString(heapMemoryUsage.getInit()));
        this.propertyMap.put("Heap Memory Usage-Max", Long.toString(heapMemoryUsage.getMax()));
        this.propertyMap.put("Heap Memory Usage-Used", Long.toString(heapMemoryUsage.getUsed()));
        MemoryUsage nonHeapMemoryUsage = this.memoryBean.getNonHeapMemoryUsage();
        this.propertyMap.put("Non-Heap Memory Usage-Commited", Long.toString(nonHeapMemoryUsage.getCommitted()));
        this.propertyMap.put("Non-Heap Memory Usage-Init", Long.toString(nonHeapMemoryUsage.getInit()));
        this.propertyMap.put("Non-Heap Memory Usage-Max", Long.toString(nonHeapMemoryUsage.getMax()));
        this.propertyMap.put("Non-Heap Memory Usage-Used", Long.toString(nonHeapMemoryUsage.getUsed()));
    }

    @Override
    public InfoObject[] getInfo(boolean isSupportBundles) {
        ArrayList<InfoObject> infoList = new ArrayList<InfoObject>();
        Set<String> keys = this.propertyMap.keySet();
        for (String key : keys) {
            infoList.add(new InfoObject(key, this.propertyMap.get(key)));
        }
        return infoList.toArray(new InfoObject[infoList.size()]);
    }

    @Override
    protected String getGroupName() {
        return "Host Info";
    }
}

