/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.config;

import org.jfrog.support.common.CollectConfiguration;

import java.util.Optional;

/**
 * Configuration files collection configuration
 *
 * @author Michael Pasternak
 */
public class ConfigFilesConfiguration extends CollectConfiguration {

    private boolean hideUserDetails = true;

    /**
     * serialization .ctr
     */
    public ConfigFilesConfiguration() {
    }

    public ConfigFilesConfiguration(boolean enabled, Optional<Boolean> hideUserDetails) {
        super(enabled);
        if (hideUserDetails.isPresent()) {
            this.hideUserDetails = hideUserDetails.get();
        }
    }

    public boolean isHideUserDetails() {
        return hideUserDetails;
    }
}
