/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.validator;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class NameValidator {
    private static final List<Character> illegalCharacters = Lists.newArrayList((Object[])new Character[]{Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf(':'), Character.valueOf('|'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>')});

    public static Optional<String> validate(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Optional.of("Name cannot be blank");
        }
        if (name.equals(".") || name.equals("..") || name.equals("&")) {
            return Optional.of("Name cannot be empty link: '" + name + "'");
        }
        if (name.chars().anyMatch(chr -> illegalCharacters.contains(Character.valueOf((char)chr)))) {
            return Optional.of("Illegal name : '/,\\,:,|,?,<,>,*,\"' is not allowed");
        }
        return Optional.empty();
    }
}

